package pl.psnc.expres.remote.network.perfsonar;

import javax.xml.namespace.QName;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding; //import org.apache.axis.client.Call;
//import org.apache.axis.client.Service;
//import org.apache.axis.message.SOAPBodyElement;
import org.w3c.dom.Document;

/**
 * Class is responsible for requesting measurements from PerfSONAR commandlineMP
 * client
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 * 
 */
public class PerfSonarClient {

	/**
	 * Method request measurement from Personar client
	 * 
	 * @param endPoint
	 * @param request
	 * @return
	 */

	public Document request(String endPoint, Document request)
			throws PerfsonarClientException {

		Service service = Service.create(new QName("http://soapinterop.org/",
				"submit"));
		service.addPort(new QName("http://soapinterop.org/", "submit"),
				SOAPBinding.SOAP11HTTP_BINDING, endPoint + "?wsdl");

		Dispatch<DOMSource> disp = service.createDispatch(new QName(
				"http://soapinterop.org/", "submit"), DOMSource.class,
				Service.Mode.PAYLOAD);

		DOMSource r = new DOMSource(request.getDocumentElement());
		DOMSource response = disp.invoke(r);
		DOMResult domResult = new DOMResult();

		// Perform the transformation, placing the output in the DOMResult.
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer;
		try {
			transformer = tFactory.newTransformer();
			transformer.transform(response, domResult);
			return (org.w3c.dom.Document) domResult.getNode();
		} catch (Exception e) {
			throw new PerfsonarClientException(e);
		}
		
		/*
		 * QName serviceName = new QName("http://soapinterop.org/", "submit");
		 * Service s = Service.create(serviceName); QName portName = new
		 * QName("http://org.apache.cxf", "stockQuoteReporterPort");
		 * Dispatch<DOMSource> dispatch = createDispatch(portName,
		 * DOMSource.class, Service.Mode.PAYLOAD);
		 * 
		 * 
		 * Service service = new Service();
		 * 
		 * Call call; try { call = (Call) service.createCall();
		 * call.setTargetEndpointAddress(new URL(endPoint)); call
		 * .setOperationName(new QName("http://soapinterop.org/", "submit"));
		 * final SOAPBodyElement requestMessage = new SOAPBodyElement(request
		 * .getDocumentElement()); double startTime = new
		 * Long(System.currentTimeMillis()) .doubleValue(); Object resultObject
		 * = call.invoke(new Object[] { requestMessage }); double endTime = new
		 * Long(System.currentTimeMillis()).doubleValue(); final SOAPBodyElement
		 * resultSBE; Document result = null; resultSBE = (SOAPBodyElement)
		 * ((Vector) resultObject).get(0); result = resultSBE.getAsDocument();
		 * return result; } catch (Exception e) { e.printStackTrace(); throw new
		 * PerfsonarClientException(e); }
		 */
	}
}
