package pl.psnc.expres.remote.network.parsers;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;

/**
 *  Helper class for manipulating xml file
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class XMLDomTools {
	/**
	 * Finds child in node with provided name
	 * 
	 * @param node Node on which we search child
	 * @param name name of searched child
	 * @return found node or null if not
	 */
	public static Node findChildInNode (Node node, String name){
		NodeList nodes = node.getChildNodes();
		Node child;
		Node result = null;
		int length = nodes.getLength();
		for (int i=0;i<length;i++){
			child = nodes.item(i);
			if (child.getNodeType()== Node.ELEMENT_NODE && child.getNodeName().equals(name)){
				result= child;
				break;
			}
		}
		return result;
	}
	public static Node findChildWithAttributeValue (Node node, String name, String attriute, String value){
		NodeList nodes = node.getChildNodes();
		Node child;
		Node result = null;
		Node attribute=null;
		int length = nodes.getLength();
		for (int i=0;i<length;i++){
			child = nodes.item(i);
			if (child.getNodeType()== Node.ELEMENT_NODE && child.getNodeName().equals(name)){
				attribute = child.getAttributes().getNamedItem(attriute);
				if (attribute == null)
					continue; 
				if (attribute.getNodeValue().equals(value)){
					result = child;
					break;
				}
			}
		}
		return result;
		
	}
	/**
	 * Adds attribute for xml node
	 * 
	 * @param document XML Document
	 * @param element modifying node
	 * @param name	name of new attribute
	 * @param value	value of new attribute
	 */
	public static  void addAttributeForElement (Document document, Node element, String name, String value){
		Attr attr = document.createAttribute(name);
		attr.setValue(value);
		element.getAttributes().setNamedItem(attr);
	}
	
	/**
	 * Fill the values provided at map in Node children. Put values 
	 * at child which attribute name is the same as key in the map 
	 * 
	 * 
	 * @param parent	parent node
	 * @param parameters parameters values
	 * @throws CannotCreateRequestException if parent node is null
	 */
	public static void fillChildsForNode (Node  parent, Map<String, String> parameters) throws ParserException{
		if (parent== null)
			throw new ParserException ("Wrong template format exception: Missing owamp:paramaters section");
		
		NodeList nodes = parent.getChildNodes();
		Node node;
		int length = nodes.getLength();
		Node attr;
		String parameter;
		for (int i=0;i<length;i++){
			node =nodes.item(i);
			if (node.getNodeType()==Node.ELEMENT_NODE){
				attr = node.getAttributes().getNamedItem("name");
				parameter = parameters.get(attr.getNodeValue());
				if (parameter!=null){
					node.setTextContent(parameter);
				}
			}
		}	
	}
	public static String xmlToStringFormated (Document  doc){
        	// Prepare the output file
            StringWriter writer = new StringWriter();
            
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            format.setIndent(4);

            XMLSerializer serializer = new XMLSerializer(writer, format);
            try {
				serializer.serialize(doc);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
            return writer.getBuffer().toString();
    }
	
	
	public static String xmlToString (Document  doc){
	        try {
	            // Prepare the DOM document for writing
	            Source source = new DOMSource(doc);
	            // Prepare the output file
	            StringWriter writer = new StringWriter();
	            
	            
	            Result result = new StreamResult(writer);
	    
	            // Write the DOM document to the file
	            Transformer xformer = TransformerFactory.newInstance().newTransformer();
	            
	            xformer.transform(source, result);
	            return writer.getBuffer().toString();
	        } catch (TransformerConfigurationException e) {
	        } catch (TransformerException e) {
	        }
	        return "";
	    }
	
}
