package pl.psnc.expres.remote.network.parsers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Factory is responsible for creating and getting parser for various 
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class ParsersFactory {
	/**
	 * Identifies configuration path for parsers templates
	 */
	public String configurationsPath;
	/**
	 * Stores all configured parsers
	 */
	Map<String, MessageParser> parsers = new HashMap<String, MessageParser>();
	/**
	 * Logger
	 */
	Log logger = LogFactory.getLog(ParsersFactory.class);
	
	/**
	 * Initialize all parsers
	 */
	public void init (){
		MessageParser parser=null;
		for (String key: parsers.keySet()){
			parser = parsers.get(key);
			if (parser== null)
				parsers.remove(key);
			try {
				parser.init(configurationsPath);
			} catch (ParserException e) {
				e.printStackTrace();
				parsers.remove(key);
				logger.error("Problem with loading template for parser:"+key+":"+e.getClass().getName()+":"+e.getMessage());
			}
		}
	}
	/**
	 * Get parser identified by its name 
	 * 
	 * @param name name of the parser
	 * @return
	 */
	public MessageParser getParser(String name){
		MessageParser parser = parsers.get(name);
		return parser;
	}
	
	public String getConfigurationsPath() {
		return configurationsPath;
	}

	public void setConfigurationsPath(String configurationsPath) {
		this.configurationsPath = configurationsPath;
	}

	public Map<String, MessageParser> getParsers() {
		return parsers;
	}
	public void setParsers(Map<String, MessageParser> parsers) {
		this.parsers = parsers;
	}	
}
