package pl.psnc.expres.remote.network.parsers;

import java.util.Comparator;
/**
 * Compares the values of delays
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public class DoubleComparator implements Comparator<Double>{

	public int compare(Double o1, Double o2) {
		if (o1 != null && o2 ==null)
			return -1;
		if (o1 ==null && o2 != null)
			return 1;
		if (o1 == null && o2==null)
			return 0;
		double delay1 = o1.doubleValue();
		double delay2 = o2.doubleValue();

		if (delay1>delay2)
			return 1;
		if (delay1==delay2)
			return 0;
		if (delay1<delay2)
			return -1;
		return 0;	
	}
}
