package pl.psnc.expres.remote.network.executors;

import java.util.Map;
import org.w3c.dom.Document;

import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.network.parsers.MessageParser;
import pl.psnc.expres.remote.network.perfsonar.PerfSonarClient;

/**
 * Class executes Task which use the PerfSONAR NMWG style communication
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 */
public class NMWGTaskExecutor implements Executor {

	public void init() throws ExecutorException {
	}

	public void execute(ResourceValue source, ResourceValue destination,
			Map<String, String> parameters, MessageParser parser,
			Map<String, Object> result) throws ExecutorException {
		if (parser == null)
			return;
		result.clear();
		PerfSonarClient client = new PerfSonarClient();
		Document request;
		try {
			// System.out.println ("requesting:"+source.getService());
			request = parser.createRequestDocument(destination, parameters);
			if (request == null)
				return;
			Document document = client.request(source.getMeasurementServiceLocation(), request);
			//System.out.println(XMLDomTools.xmlToStringFormated(document));
			parser.decodeMessageDocument(document, result);
		} catch (Exception e) {
			e.printStackTrace();
			throw new ExecutorException(e);
		}
	}
}
