package pl.psnc.expres.remote.network.executors;

import java.util.Map;

import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.network.parsers.MessageParser;


/**
 * Interface for executing various kind of tasks
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */
public interface Executor {
	/**
	 * Executes task
	 * 
	 * @param parameters	task execution parameters
	 * @param parser		parser for creating requests and decode response
	 * @param service		url address for service	
	 * @param result		map where results will be stored
	 * @throws ExecutorException	
	 */
	public void execute(ResourceValue source, ResourceValue destination, Map<String, String> parameters, MessageParser parser, Map<String, Object>result) throws ExecutorException;
	/**
	 * Initializes the executor object
	 * @throws ExecutorException
	 */
	public void init() throws ExecutorException;
}
