package pl.psnc.expres.remote.network;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.factory.ResourceFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.remote.network.requester.Requester;
import pl.psnc.expres.remote.network.requester.RequesterObserver;
import pl.psnc.expres.remote.network.sessions.BandwidthQueringSessionStage;
import pl.psnc.expres.remote.network.sessions.DelayQueringSessionStage;
import pl.psnc.expres.remote.network.sessions.MultiStageSession;
import pl.psnc.expres.remote.network.sessions.Session;
import pl.psnc.expres.remote.network.sessions.SessionExeception;
import pl.psnc.expres.remote.network.sessions.SessionObserver;
import pl.psnc.expres.remote.network.task.InvalidTaskTypeException;
import pl.psnc.expres.remote.network.task.MeasurementTask;
import pl.psnc.expres.remote.network.task.MeasurementTaskFactory;
import pl.psnc.expres.remote.network.value.NetworkMetric;

/**
 * NetworkMonitorManager class is main class of the NetworkMonitor system.
 * 
 * @author Lucas Dolata <ldolata@man.poznan.pl>
 *
 */

@javax.jws.WebService(name = "INetworkMonitor",
        serviceName="INetworkMonitorService",
        portName="INetworkMonitorPort",
		targetNamespace = "http://network.remote.expres.psnc.pl/", 
        wsdlLocation = "file:etc/networkmonitor.wsdl" ,
        endpointInterface = "pl.psnc.expres.remote.network.INetworkMonitor")
public class NetworkMonitor implements INetworkMonitor,INetworkMonitorManager, RequesterObserver, SessionObserver{
	
	/**Manager configuration location path*/
	String configurationPath;
	
	/**Configured measurement points*/
	private  ConcurrentHashMap<Integer, ResourceValue> points = new ConcurrentHashMap<Integer, ResourceValue>();
	
	/**Identifies task requester*/
	private Requester requester;
	
	/**Requested sessions*/
	private  ConcurrentHashMap <Integer,Session> sessions = new ConcurrentHashMap<Integer,Session>();  
	
	/** Factory for creating tasks*/
	private MeasurementTaskFactory factory;
	
	/**Interface for transition nodes and file servers  configuration provider*/
	private IVlbiBrokerInfo brokerInfo;
	
	/** Logs all information during application life time */
	Log logger = LogFactory.getLog("NetworkMonitorManager");
	
	
	
	/**
	 * Creates the NetworkMonitorManager with configuration file located at provided path
	 * @throws NetworkMonitorException exception throws if some of manager modules will generate error durring initializations
	 */
	private List<INetworkMetricNotification> networkMonitorMetricsNotifier = new ArrayList<INetworkMetricNotification>();
	
	public void start(){
		String resource = brokerInfo.getFileServerList();
		//List<ResourceValue> servers = ResourceFactory.getResources(new StringBuffer(resource));
		requester.start();
	}
	
	public MeasurementTaskFactory getFactory() {
		return factory;
	}
	public void setFactory(MeasurementTaskFactory factory) {
		this.factory = factory;
		this.factory.setManager(this);
	}
	public void addMeasurementTask(MeasurementTask task){
		requester.execute(task);
	}

	public List<NetworkMetric> getNetworkMetric(int networkOrderId) {
		Session session = sessions.get(networkOrderId);
		if (session != null && session.isComplete())
			return session.getNetworkMetrics();
		return null;
	}

	public int orderNetworkMetric(List<Integer> translationNodes, List<Integer> fileServers, long bandwidth) {
		
		logger.info("Ordering metric:"+":"+translationNodes+":"+fileServers);
		if (points==null || points.isEmpty())
			return -1;
		MultiStageSession session = new MultiStageSession();
		session.setStartPoints(translationNodes);
		session.setEndPoints(fileServers);
		session.addSessionStage( new DelayQueringSessionStage());
		session.addSessionStage(new BandwidthQueringSessionStage());
		sessions.put(session.getIdentifier(), session);
		session.setBandwidth(bandwidth);
		session.setObserver(this);
		try {
			session.start();
			logger.info("Ordering metric:"+session.getIdentifier()+":"+translationNodes+":"+fileServers);
			return session.getIdentifier();
		} catch (SessionExeception e) {
			e.printStackTrace();
		}
		return -1;
	}
	
	public ResourceValue getEndPoint(int index) {
		return points.get(index);
	}
	public void addObserver(int networkOrderId, String location) {
		
		
	}
	public void taskComplete(MeasurementTask task) {
		if (task == null)
			return;
	//	System.out.println ("Complete:"+task.getSource().getHost()+":"+task.getDestination().getHost());
		Session session = sessions.get(task.getSession());
		if (session != null)
			try {
				session.update(task, true);
			} catch (SessionExeception e) {
				e.printStackTrace();
			}
	}
	public void taskFailed(MeasurementTask task) {
		//System.out.println ("Failed:"+task.getSource().getHost()+":"+task.getDestination().getHost());
		Session session = sessions.get(task.getSession());
		if (session != null)
			try {
				session.update(task, false);
			} catch (SessionExeception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	
	public MeasurementTask requestSessionTask(String type,
			int startPointIdentifier, int endPointIdentifier,
			int sessionIdentifier) throws InvalidTaskTypeException {
		ResourceValue src = points.get(startPointIdentifier);
		ResourceValue dst = points.get(endPointIdentifier);
		
		System.out.println ("requests:"+type+":"+src.getName()+":"+dst.getName());
		if (src== null || dst == null)
			return null;
		MeasurementTask task =
			this.factory.createMeasuremetTask(type, src,dst, sessionIdentifier);
		requester.execute(task);
		
		return task;
	}
	public Requester getRequester() {
		return requester;
	}

	public void setRequester(Requester requester) {
		this.requester = requester;
		this.requester.setObserver(this);
	}

	public void sessionCompleted(int ses) {
		
			
	}
	public void updateSessionState(long sessionId, int sessionState) {
		// TODO Auto-generated method stub
		
	}
	public void sessionCompleted() {
		// TODO Auto-generated method stub
		
	}
	public void updateSessionState(int sessionId, int sessionState) {
		// TODO Auto-generated method stub
		
	}
	
	public ConcurrentHashMap<Integer, ResourceValue> getPoints() {
		return points;
	}
	public void setPoints(ConcurrentHashMap<Integer, ResourceValue> points) {
		this.points = points;
	}
	
}


