/**
 * Created on 6 Jan 2009
 */
package pl.psnc.expres.model.resource.helper;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.factory.ResourceTypeFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.model.type.ResourceType;
import pl.psnc.vlab.exception.ResourceNotFoundException;

/**
 * {@link ResourceHelper} class - set of utility methods for resource objects
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class ResourceHelper {

	/** Stores instance of field: log */
	private final static Log log = LogFactory.getLog(ResourceHelper.class);

	/**
	 * Get a list of resources with a given type from the resource list
	 * 
	 * @param <T> resource type
	 * @param resourceList resource list
	 * @param concreteType class instance of the given resource type
	 * @return
	 */
	public static <T> List<ResourceValue> getConcreteTypes(List<ResourceValue> resourceList,
			Class<T> concreteType) {
		if (resourceList == null || resourceList.size() == 0) {
			return null;
		}
		List<ResourceValue> result = new ArrayList<ResourceValue>();
		for (ResourceValue rValue : resourceList) {
			try {
				ResourceType resourceType = ResourceTypeFactory.getResourceType(rValue.getTypeId());
				if (resourceType != null && resourceType.getClass() == concreteType) {
					result.add(rValue);
				}
			} catch (ResourceNotFoundException e) {
				log.error(e.getMessage());
				continue;
			}
		}
		return result;
	}
}
