/*
 * VlabRemoteImpl.java
 *
 * Created on 9 marzec 2004, 13:23
 */

package pl.psnc.expres.wfm.remote.scenario;

import javax.swing.Action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.exception.WfmException;
import pl.psnc.vlab.util.swing.thread.LongTask;

/**
 * This is an implementation of the interface to the VLBI Broker
 * 
 * @author osa
 * @email osa@man.poznan.pl
 */
public class SubmitWorkflowTask implements LongTask {
	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Long tastk status */
	private boolean done = false;

	/** The JGraph */
	private String jgxFile = null;
	/** The Resources description */
	private String resources = null;

	/** Stores action object which invoked this thread */
	private final Action action;

	/** Represents an exception */
	private WfmException exception = null;

	/** Result object produced by the executed task */
	private String result = null;

	/**
	 * Creates a new instance of SendScenarioTask, which automatically starts
	 * new thread which send new scenario to the VLab System
	 * 
	 * @param scenarioDetails scenario details object
	 * @param in input datagram with scenario description
	 */
	public SubmitWorkflowTask(final Action action, String jgxFile, String resources) {
		this.jgxFile = jgxFile;
		this.resources = resources;
		this.action = action;
//		final SwingWorker worker = new SwingWorker() {
//			public Object construct() {
//				SubmitVlbiExperimentStub.VlbiExperiment vlbiExperiment = new SubmitVlbiExperimentStub.VlbiExperiment();
//				vlbiExperiment.setCcf(new DataHandler(new ByteArrayDataSource("ccf -> kupa gowna".getBytes())));
//				
//				//vlbiExperiment.setVexFile("vex -> kupa gowna".getBytes("utf-8"));
//				//vlbiExperiment.setWorkflow("workflow -> kupa gowna".getBytes("utf-8"));
//				SubmitVlbiExperimentStub.NewVlbiExperiment newVlbiExperiment = new SubmitVlbiExperimentStub.NewVlbiExperiment();
//				newVlbiExperiment.setParam0(vlbiExperiment);
//				return new ActualSendScenarioTask(newVlbiExperiment);
//			}
//
//			public void finished() {
//				// action.setEnabled(true);
//				// JMainFrame.getInstance().update(getTask());
//			}
//		};
//		worker.start();
	}
	public boolean isDone() {
		return this.done;
	}

	public Object getResult() {
		return this.result;
	}

	public Exception getException() {
		return this.exception;
	}

	public int getCurrent() {
		return 0;
	}

	public int getTaskLength() {
		return 0;
	}

	/**
	 * tbd Get the current state of the executed task
	 * 
	 * @return the current state of the executed task (where <CODE>getTaskLength()
	 *         is max size </CODE>
	 */
	public int getProgress() {
		return 0;
	}

	private LongTask getTask() {
		return this;
	}

	public boolean exceptionThrown() {
		return !(exception == null);
	}

	/**
	 * The actual long running task. This runs in a SwingWorker thread.
	 */
//	class ActualSendScenarioTask {
//		ActualSendScenarioTask(SubmitVlbiExperimentStub.NewVlbiExperiment newVlbiExperiment) {
//			try {
//				log.debug("<sendScenario>");
//				WfmConfiguration confVO = (WfmConfiguration) ConfigFactory
//						.getConfigFactory();
//				SubmitVlbiExperimentStub vlbiStub = new SubmitVlbiExperimentStub(confVO
//						.getVlbiBrokerServiceLocation());
//				
//				vlbiStub.newVlbiExperiment(newVlbiExperiment);
//				log.debug("</sendScenario>");
//			} catch (java.lang.Exception er) {
//				done = true;
//				log.debug("</sendScenario-err:" + er.getMessage());
//				result = er.getLocalizedMessage();
//				exception = new WfmException(er.getLocalizedMessage(), er);
//			}
//		}

//	}

}
