/**
 * ResourceFactory.java
 * Created on Nov 15, 2007, 3:40:34 PM
 */
package pl.psnc.expres.wfm.model.factory;

import pl.psnc.expres.model.type.ResourceType;
import pl.psnc.expres.wfm.management.WfmConfiguration;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.exception.VlabException;

/**
 * Factory class for retrieving resources types and their properties
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class TypeFactory {

	/**
	 * Get resource type by the given id
	 * 
	 * @param id resource type id
	 * @return resource type value object
	 */
	public static ResourceType getResourceType(int id) throws ResourceNotFoundException {
		try {
			WfmConfiguration configVo = (WfmConfiguration) ConfigFactory.getConfigFactory();
			return pl.psnc.expres.model.factory.ResourceTypeFactory.getResourceType(id, configVo
					.getResourceTypesLocation());
		} catch (VlabException e) {
			throw new ResourceNotFoundException(e.getMessage(), e);
		}
	}

}
