/**
 * LinkFactory.java
 * Created on Nov 15, 2007, 3:40:34 PM
 */
package pl.psnc.expres.wfm.model.factory;

import java.util.Iterator;
import java.util.List;

import pl.psnc.expres.model.link.LinkValue;
import pl.psnc.expres.wfm.management.WfmConfiguration;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.exception.VlabException;

/**
 * Factory class for retrieving resources links definition
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class LinkFactory {

	/**
	 * Check whether two resources can be connected (by link)
	 * 
	 * @param source resource source identifier
	 * @param dest resource target identifier
	 * @return <code>true</code> if resources can be connected, false
	 *         otherwise
	 */
	public static boolean canConnect(int source, int dest) throws ResourceNotFoundException {
		try {
			WfmConfiguration configVo = (WfmConfiguration) ConfigFactory.getConfigFactory();
			List<LinkValue> links = pl.psnc.expres.model.factory.ResourceLinksFactory
					.getResourceLinks(configVo.getResourceTypesLocation());
			Iterator<LinkValue> it = links.iterator();
			while (it.hasNext()) {
				LinkValue tmpLink = it.next();
				if (tmpLink.getSourceId() == source && tmpLink.getTargetId() == dest) {
					return true;
				}
			}
			return false;
		} catch (VlabException e) {
			throw new ResourceNotFoundException(e.getMessage(), e);
		}
	}

}
