/*
 * WfmConfiguration.java
 *
 * Created on February 21, 2006, 3:34 PM
 *
 */

package pl.psnc.expres.wfm.management;

import pl.psnc.vlab.conf.IConfiguration;

/**
 * SSA configuration keys and methods
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public interface WfmConfiguration extends IConfiguration {

	/** Specifies the location of the file with the predefined scenarios */
	static final String KEY_DEVICE_LOCATION = "deviceLocation";

	/** Key value for resource types */
	static final String KEY_RESOURCE_TYPES = "model.resource.types";

	/** Key value for resource links */
	static final String KEY_RESOURCE_LINKS = "model.resource.links";

	/** Key value for resource properties */
	static final String KEY_RESOURCE_PROPERTIES = "model.resource.properties";

	/** Key value: location of VLBI Broker Service */
	static final String KEY_VLBI_BROKER_LOCATION = "vlbi.broker.location";

	/**
	 * Returns the location of the file containing the devices
	 * 
	 * @return predefined scenarios location
	 */
	public String getDeviceLocation();

	/**
	 * Returns a location of resource types
	 * 
	 * @return location of resource types
	 */
	public String getResourceTypesLocation();

	/**
	 * Returns a location of resource links
	 * 
	 * @return location of resource links @
	 */
	public String getResourceLinksLocation();

	/**
	 * Returns a location of resource properties
	 * 
	 * @return location of resource properties @
	 */
	public String getResourcePropertiesLocation();

	/**
	 * Returns a location (endpoint) of VLBI Broker Service
	 * 
	 * @return location location of VLBI Broker Service @ thrown if location
	 *         cannot be found
	 */
	public String getVlbiBrokerServiceLocation();

}
