/*
 * AppInitializer.java
 *
 * Created on 9 sierpie� 2004, 15:13
 */

package pl.psnc.expres.wfm.management;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.exception.WfmException;
import pl.psnc.expres.wfm.gui.about.SplashDialog;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.vlab.util.swing.gui.Message;
import pl.psnc.vlab.util.swing.thread.LongTask;
import pl.psnc.vlab.util.swing.thread.SwingWorker;

/**
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public class AppInitializer implements LongTask {

	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Represents an exception */
	private WfmException dynExc = null;

	/** Long tastk status */
	private boolean done = false;

	/** Instance of the Splash Dialog */
	private SplashDialog splashDialog = null;

	/** Creates a new instance of AppInitializer */
	public AppInitializer(SplashDialog splashDialog) {
		this.splashDialog = splashDialog;
		final SwingWorker worker = new SwingWorker() {
			public Object construct() {
				return new Init();
			}

			public void finished() {
				if (dynExc != null) {
					Message.showInfoMessage(null, dynExc.getMessage(), Message.MESSAGE_TYPE_ERROR);
				}
			}
		};
		worker.start();
	}

	public boolean exceptionThrown() {
		return dynExc != null;
	}

	public int getCurrent() {
		return 0;
	}

	public Exception getException() {
		return dynExc;
	}

	public Object getResult() {
		return null;
	}

	public int getTaskLength() {
		return 0;
	}

	public boolean isDone() {
		return done;
	}

	// tbd
	public int getProgress() {
		return 0;
	}

	/**
	 * The actual long running task. This runs in a SwingWorker thread.
	 */
	class Init {
		Init() {
			try {
				log.debug("<Init>");
				splashDialog.setMessage(BundleFactory.getMessageValue("message.init"));
				splashDialog.setMessage(BundleFactory.getMessageValue("message.init.start.app"));
				done = true;
				log.debug("</Init>");
			} catch (java.lang.Exception er) {
				// er.printStackTrace();
				done = true;
				log.debug("</Init-Err>");
				dynExc = new WfmException("Error while initializing class: " + er.getMessage(), er);
			}

		}
	}// end of Init class
}