/*
 * NumberDocument.java
 *
 * Created on 9 lipiec 2004, 13:20
 */

package pl.psnc.expres.wfm.gui.resource.document;

import java.awt.Toolkit;

import javax.swing.event.DocumentEvent.EventType;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.FormTools;

/**
 * The Document is a container for text that serves as the model for swing text components.
 * The document accepts only normalized characters and numbers
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email  osa@man.poznan.pl
 */
public class NormalizedDocument extends PlainDocument{
    
    /** Logger instance */
    public Log log = LogFactory.getLog(this.getClass().getName());
    
    
    public char CHAR_SPACE = ' ';
    
    public char CHAR_NEW_LINE = '\n';
    
    /** Maximum length of the characters that can be inserted */
    private int maxLength;
    
    /** Stores tooltip text: max exceeded */
    private String maxLengthExceeded;
    
    /** Stores tooltip text: invalid character */
    private String invalidCharacter;
    
    /**
     * Creates a new instance of NumberDocument
     * @param maxLength maximum number of characters that may be inserted
     * @param maxLengthExceeded tooltip text displayed when maximum characters alowed is reached
     * @param invalidCharacter tooltip text displayed when invalid characters are inserted
     */
    public NormalizedDocument(int maxLength, String maxLengthExceeded, String invalidCharacter) {
        this.maxLength = maxLength;
        this.maxLengthExceeded = maxLengthExceeded;
        this.invalidCharacter = invalidCharacter;        
    }
    
    
    /** This inner class represents the DocumentEvent, which is fired whenever
     * not allowed characters are inserted.
     */
    public class UpdateTooltipDocEvent extends AbstractDocument.DefaultDocumentEvent{
        
        public UpdateTooltipDocEvent(int offset, int lenght, EventType type, String toolTip){
            super(offset, lenght, type );
            this.toolTip = toolTip;
        }

        /**
         * Holds value of property toolTip.
         */
        private String toolTip;

        /**
         * Getter for property toolTip.
         * @return Value of property toolTip.
         */
        public String getToolTip() {
            return this.toolTip;
        }

    }
    
    /**
     * Inserts a string of content.  
     * @param offset  the offset into the document to insert the content >= 0.
     *    All positions that track change at or after the given location
     *    will move.
     * @param str    the string to insert
     * @param a      the attributes to associate with the inserted
     *   content.  This may be null if there are no attributes.
     * @exception BadLocationException  the given insert position is not a valid
     * position within the document
     */
    public void insertString(int offset, String str, javax.swing.text.AttributeSet attr) throws javax.swing.text.BadLocationException {
        if(getLength() + str.length() > maxLength){
            Toolkit.getDefaultToolkit().beep();
            fireChangedUpdate(new UpdateTooltipDocEvent(offset, getLength(), EventType.CHANGE, this.maxLengthExceeded));
            return;
        }
        
        int size = str.length();
        StringBuffer result  = new StringBuffer(size);
        
        for(int i=0; i<size; i++){
            char ch = str.charAt(i);
            if( Character.isWhitespace(ch) && offset == 0){
                fireChangedUpdate(new UpdateTooltipDocEvent(offset, getLength(), EventType.CHANGE, this.invalidCharacter));
                continue;
            }
            
            if( Character.isLetterOrDigit(ch) ||
                    ch == '_' || ch == '-' ||
                    Character.isWhitespace(ch)){
                result.append(ch);
            } else {
                fireChangedUpdate(new UpdateTooltipDocEvent(offset, getLength(), EventType.CHANGE, this.invalidCharacter));
            }
        } // end of for
        
        String value = result.toString();
        if(!FormTools.isValidateFormStringNull(value)){
            super.insertString(offset, str, attr);
        }
        return;
    }
    
    
    
    
}
