/*
 * Created by JFormDesigner on Wed Mar 05 15:47:34 CET 2008
 */

package pl.psnc.expres.wfm.gui.perspective.workflow;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ResourceBundle;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.graph.marquee.WfmMarqueeHandler;
import pl.psnc.expres.wfm.gui.scenario.JScenarioDetailsPane;
import pl.psnc.graph.exception.GraphException;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.gui.JGraphPane;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.vlab.util.gui.frame.GenericGradientPane;
import pl.psnc.vlab.util.gui.message.JMessage;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * {@link WorkflowDesignPane} class - workflow desgin pane.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class WorkflowDesignPane extends JPanel {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Logger instance */
	private Log log = LogFactory.getLog(WorkflowDesignPane.class);

	/**
	 * Creates a new instance of {@link WorkflowDesignPane}
	 */
	public WorkflowDesignPane() {
		try {
			initComponents();
			initGraphComponent();
		} catch (Exception e) {
			JMessage.showErrorMessage(this, e);
		}
	}

	/**
	 * Initialises form components
	 */
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
		jLeftSplitPane = new UIFSplitPane();
		jScenarioDetailsPane = new JScenarioDetailsPane();
		jGraphEditorIFr = new SimpleInternalFrame();
		JGraphEditorScrollPane = new JScrollPane();
		JViewToolBar = new JToolBar();
		jViewChanger = new JComboBox();
		JContentScrollPane = new JScrollPane();
		jContentPane = new JPanel();
		jResoureTypeTile = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jResoureTypeTile.text"));
		jResourceTypeTF = new JLabel();
		jResourceNameTile = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jResourceNameTile.text"));
		jResourceNameTF = new JLabel();
		jResourceDescTile = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jResourceDescTile.text"));
		jResourceDescTA = new JTextArea();
		jLinkContentPane = new GenericGradientPane(new Color(203, 201, 188), Color.white);
		goodiesFormsTitle1 = compFactory.createTitle(bundle
				.getString("workflow.design.pane.goodiesFormsTitle1.textWithMnemonic"));
		jSrcNodeIdTitle = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jSrcNodeIdTitle.text"));
		jSrcNodeIdTxtFld = new JTextField();
		jSrcNodeNameTitle = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jSrcNodeNameTitle.text"));
		jSrcNodeNameTxtFld = new JTextField();
		goodiesFormsTitle2 = compFactory.createTitle(bundle
				.getString("workflow.design.pane.goodiesFormsTitle2.textWithMnemonic"));
		jTrgtNodeIdTitle = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jTrgtNodeIdTitle.text"));
		jTrgtNodeIdTxtFld = new JTextField();
		jTrgtNodeNameTitle = compFactory.createSeparator(bundle
				.getString("workflow.design.pane.jTrgtNodeNameTitle.text"));
		jTrgtNodeNameTxtFld = new JTextField();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
		setName("this");
		setLayout(new FormLayout("default:grow", "fill:default:grow"));

		// ======== jLeftSplitPane ========
		{
			jLeftSplitPane.setResizeWeight(0.1);
			jLeftSplitPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			jLeftSplitPane.setDividerSize(4);
			jLeftSplitPane.setToolTipText(bundle
					.getString("workflow.design.pane.jLeftSplitPane.toolTipText"));
			jLeftSplitPane.setContinuousLayout(true);
			jLeftSplitPane.setName("jLeftSplitPane");

			// ---- jScenarioDetailsPane ----
			jScenarioDetailsPane.setName("jScenarioDetailsPane");
			jLeftSplitPane.setLeftComponent(jScenarioDetailsPane);

			// ======== jGraphEditorIFr ========
			{
				jGraphEditorIFr.setTitle("Top");
				jGraphEditorIFr.setContentPaneBorder(null);
				jGraphEditorIFr.setPreferredSize(new Dimension(400, 200));
				jGraphEditorIFr.setFrameIcon(new ImageIcon(getClass().getResource(
						"/images/eclipse/menu/ch_callers.gif")));
				jGraphEditorIFr.setToolBar(JViewToolBar);
				jGraphEditorIFr.setName("jGraphEditorIFr");
				Container jGraphEditorIFrContentPane = jGraphEditorIFr.getContentPane();
				jGraphEditorIFrContentPane.setLayout(new FormLayout("default:grow",
						"fill:default:grow"));

				// ======== JGraphEditorScrollPane ========
				{
					JGraphEditorScrollPane.setBorder(Borders
							.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
					JGraphEditorScrollPane.setName("JGraphEditorScrollPane");
				}
				jGraphEditorIFrContentPane.add(JGraphEditorScrollPane, cc.xy(1, 1));
			}
			jLeftSplitPane.setRightComponent(jGraphEditorIFr);
		}
		add(jLeftSplitPane, cc.xy(1, 1));

		// ======== JViewToolBar ========
		{
			JViewToolBar.setOpaque(false);
			JViewToolBar.setName("JViewToolBar");

			// ---- jViewChanger ----
			jViewChanger.setModel(new DefaultComboBoxModel(new String[] { "Europe", "World Map" }));
			jViewChanger.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			jViewChanger.setFont(new Font("Dialog", Font.PLAIN, 10));
			jViewChanger.setPreferredSize(new Dimension(75, 18));
			jViewChanger.setMinimumSize(new Dimension(75, 16));
			jViewChanger.setMaximumSize(new Dimension(32767, 18));
			jViewChanger.setEnabled(false);
			jViewChanger.setName("jViewChanger");
			JViewToolBar.add(jViewChanger);
		}

		// ======== JContentScrollPane ========
		{
			JContentScrollPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			JContentScrollPane.setOpaque(false);
			JContentScrollPane.setPreferredSize(new Dimension(0, 0));
			JContentScrollPane.setMinimumSize(new Dimension(0, 0));
			JContentScrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			JContentScrollPane.setVisible(false);
			JContentScrollPane.setName("JContentScrollPane");

			// ======== jContentPane ========
			{
				jContentPane.setMinimumSize(new Dimension(80, 65));
				jContentPane.setMaximumSize(new Dimension(32767, 1000));
				jContentPane.setPreferredSize(new Dimension(200, 300));
				jContentPane.setAutoscrolls(true);
				jContentPane.setName("jContentPane");
				jContentPane.setLayout(new FormLayout(new ColumnSpec[] {
						new ColumnSpec(ColumnSpec.LEFT, Sizes.DLUX6, FormSpec.NO_GROW),
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC,
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
						new ColumnSpec(ColumnSpec.LEFT, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
						FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX6) },
						new RowSpec[] { FormFactory.LINE_GAP_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC,
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.TOP, Sizes.dluY(12), FormSpec.NO_GROW),
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.TOP, Sizes.dluY(12), FormSpec.NO_GROW),
								FormFactory.DEFAULT_ROWSPEC,
								new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
								new RowSpec("fill:min(default;100dlu)"),
								FormFactory.LINE_GAP_ROWSPEC,
								new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }));

				// ---- jResoureTypeTile ----
				jResoureTypeTile.setName("jResoureTypeTile");
				jContentPane.add(jResoureTypeTile, cc.xywh(3, 3, 4, 1));

				// ---- jResourceTypeTF ----
				jResourceTypeTF.setBorder(null);
				jResourceTypeTF.setText(bundle
						.getString("workflow.design.pane.jResourceTypeTF.text"));
				jResourceTypeTF.setOpaque(false);
				jResourceTypeTF.setMaximumSize(new Dimension(300, 15));
				jResourceTypeTF.setName("jResourceTypeTF");
				jContentPane.add(jResourceTypeTF, cc.xy(5, 5));

				// ---- jResourceNameTile ----
				jResourceNameTile.setName("jResourceNameTile");
				jContentPane.add(jResourceNameTile, cc.xywh(3, 7, 4, 1));

				// ---- jResourceNameTF ----
				jResourceNameTF.setBorder(null);
				jResourceNameTF.setText(bundle
						.getString("workflow.design.pane.jResourceNameTF.text"));
				jResourceNameTF.setMaximumSize(new Dimension(300, 15));
				jResourceNameTF.setMinimumSize(new Dimension(24, 15));
				jResourceNameTF.setPreferredSize(new Dimension(100, 15));
				jResourceNameTF.setName("jResourceNameTF");
				jContentPane.add(jResourceNameTF, cc.xy(5, 9));

				// ---- jResourceDescTile ----
				jResourceDescTile.setName("jResourceDescTile");
				jContentPane.add(jResourceDescTile, cc.xywh(3, 11, 4, 1));

				// ---- jResourceDescTA ----
				jResourceDescTA.setTabSize(4);
				jResourceDescTA.setRows(5);
				jResourceDescTA.setBackground(new Color(225, 225, 225));
				jResourceDescTA.setText(bundle
						.getString("workflow.design.pane.jResourceDescTA.text"));
				jResourceDescTA.setMinimumSize(new Dimension(0, 0));
				jResourceDescTA.setWrapStyleWord(true);
				jResourceDescTA.setColumns(10);
				jResourceDescTA.setCaretPosition(1);
				jResourceDescTA.setPreferredSize(new Dimension(0, 0));
				jResourceDescTA.setLineWrap(true);
				jResourceDescTA.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
				jResourceDescTA.setOpaque(false);
				jResourceDescTA.setAutoscrolls(false);
				jResourceDescTA.setEditable(false);
				jResourceDescTA.setName("jResourceDescTA");
				jContentPane.add(jResourceDescTA, cc.xy(5, 13));
			}
			JContentScrollPane.setViewportView(jContentPane);
		}

		// ======== jLinkContentPane ========
		{
			jLinkContentPane.setPreferredSize(new Dimension(150, 100));
			jLinkContentPane.setMinimumSize(new Dimension(80, 65));
			jLinkContentPane.setMaximumSize(new Dimension(32767, 1000));
			jLinkContentPane.setName("jLinkContentPane");
			jLinkContentPane.setLayout(new FormLayout(new ColumnSpec[] {
					new ColumnSpec(ColumnSpec.LEFT, Sizes.DLUX6, FormSpec.NO_GROW),
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
					FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC,
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.DLUX6) },
					new RowSpec[] { FormFactory.LINE_GAP_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
							FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
							FormFactory.DEFAULT_ROWSPEC, new RowSpec(Sizes.dluY(20)),
							new RowSpec(RowSpec.TOP, Sizes.dluY(12), FormSpec.NO_GROW),
							FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							new RowSpec(RowSpec.TOP, Sizes.DLUY5, FormSpec.NO_GROW),
							FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC,
							new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW) }));

			// ---- goodiesFormsTitle1 ----
			goodiesFormsTitle1.setFont(new Font("Dialog", Font.BOLD, 14));
			goodiesFormsTitle1.setName("goodiesFormsTitle1");
			jLinkContentPane.add(goodiesFormsTitle1, cc.xywh(4, 3, 5, 1));

			// ---- jSrcNodeIdTitle ----
			jSrcNodeIdTitle.setName("jSrcNodeIdTitle");
			jLinkContentPane.add(jSrcNodeIdTitle, cc.xywh(5, 5, 4, 1));

			// ---- jSrcNodeIdTxtFld ----
			jSrcNodeIdTxtFld.setEditable(false);
			jSrcNodeIdTxtFld.setBorder(null);
			jSrcNodeIdTxtFld
					.setText(bundle.getString("workflow.design.pane.jSrcNodeIdTxtFld.text"));
			jSrcNodeIdTxtFld.setOpaque(false);
			jSrcNodeIdTxtFld.setName("jSrcNodeIdTxtFld");
			jLinkContentPane.add(jSrcNodeIdTxtFld, cc.xy(7, 7));

			// ---- jSrcNodeNameTitle ----
			jSrcNodeNameTitle.setName("jSrcNodeNameTitle");
			jLinkContentPane.add(jSrcNodeNameTitle, cc.xywh(5, 9, 4, 1));

			// ---- jSrcNodeNameTxtFld ----
			jSrcNodeNameTxtFld.setEditable(false);
			jSrcNodeNameTxtFld.setBorder(null);
			jSrcNodeNameTxtFld.setText(bundle
					.getString("workflow.design.pane.jSrcNodeNameTxtFld.text"));
			jSrcNodeNameTxtFld.setOpaque(false);
			jSrcNodeNameTxtFld.setName("jSrcNodeNameTxtFld");
			jLinkContentPane.add(jSrcNodeNameTxtFld, cc.xy(7, 11));

			// ---- goodiesFormsTitle2 ----
			goodiesFormsTitle2.setFont(new Font("Dialog", Font.BOLD, 14));
			goodiesFormsTitle2.setName("goodiesFormsTitle2");
			jLinkContentPane.add(goodiesFormsTitle2, cc.xywh(4, 13, 5, 1));

			// ---- jTrgtNodeIdTitle ----
			jTrgtNodeIdTitle.setName("jTrgtNodeIdTitle");
			jLinkContentPane.add(jTrgtNodeIdTitle, cc.xywh(5, 15, 4, 1));

			// ---- jTrgtNodeIdTxtFld ----
			jTrgtNodeIdTxtFld.setEditable(false);
			jTrgtNodeIdTxtFld.setBorder(null);
			jTrgtNodeIdTxtFld.setText(bundle
					.getString("workflow.design.pane.jTrgtNodeIdTxtFld.text"));
			jTrgtNodeIdTxtFld.setOpaque(false);
			jTrgtNodeIdTxtFld.setName("jTrgtNodeIdTxtFld");
			jLinkContentPane.add(jTrgtNodeIdTxtFld, cc.xy(7, 16));

			// ---- jTrgtNodeNameTitle ----
			jTrgtNodeNameTitle.setName("jTrgtNodeNameTitle");
			jLinkContentPane.add(jTrgtNodeNameTitle, cc.xywh(5, 18, 4, 1));

			// ---- jTrgtNodeNameTxtFld ----
			jTrgtNodeNameTxtFld.setEditable(false);
			jTrgtNodeNameTxtFld.setBorder(null);
			jTrgtNodeNameTxtFld.setOpaque(false);
			jTrgtNodeNameTxtFld.setText(bundle
					.getString("workflow.design.pane.jTrgtNodeNameTxtFld.text"));
			jTrgtNodeNameTxtFld.setName("jTrgtNodeNameTxtFld");
			jLinkContentPane.add(jTrgtNodeNameTxtFld, cc.xy(7, 21));
		}
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private UIFSplitPane jLeftSplitPane;
	private JScenarioDetailsPane jScenarioDetailsPane;
	private SimpleInternalFrame jGraphEditorIFr;
	private JScrollPane JGraphEditorScrollPane;
	private JToolBar JViewToolBar;
	private JComboBox jViewChanger;
	private JScrollPane JContentScrollPane;
	private JPanel jContentPane;
	private JComponent jResoureTypeTile;
	private JLabel jResourceTypeTF;
	private JComponent jResourceNameTile;
	private JLabel jResourceNameTF;
	private JComponent jResourceDescTile;
	private JTextArea jResourceDescTA;
	private JPanel jLinkContentPane;
	private JLabel goodiesFormsTitle1;
	private JComponent jSrcNodeIdTitle;
	private JTextField jSrcNodeIdTxtFld;
	private JComponent jSrcNodeNameTitle;
	private JTextField jSrcNodeNameTxtFld;
	private JLabel goodiesFormsTitle2;
	private JComponent jTrgtNodeIdTitle;
	private JTextField jTrgtNodeIdTxtFld;
	private JComponent jTrgtNodeNameTitle;
	private JTextField jTrgtNodeNameTxtFld;

	// JFormDesigner - End of variables declaration //GEN-END:variables

	// ---------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Initialises the jGraph component
	 */
	private void initGraphComponent() throws GraphException {
		log.debug("<initGraphComponent>");
		JGraphPane graphPane = GraphEditorFactory.createNewInstance(null);
		CustomGraph graph = graphPane.getGraph();
		graph.setMarqueeHandler(new WfmMarqueeHandler(graph));

		JGraphEditorScrollPane.add(graphPane);
		JGraphEditorScrollPane.setViewportView(graphPane);
	}

}
