/*
 * StockArticlesTableModel.java
 *
 */
package pl.psnc.expres.wfm.gui.model.table;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.remote.vex2ccf.model.CCFFrequency;
import pl.psnc.expres.wfm.gui.model.table.info.WfmColumnType;
import pl.psnc.vlab.util.gui.model.info.ColumnInfo;
import pl.psnc.vlab.util.gui.model.info.ModelProperties;
import pl.psnc.vlab.util.gui.model.info.TableModelInfo;
import pl.psnc.vlab.util.gui.model.table.AbstractCustomTableModel;

/**
 * {@link FrequencyTableModel} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class FrequencyTableModel extends AbstractCustomTableModel implements
		TableModelInfo<CCFFrequency, List<CCFFrequency>> {

	/** Default Serial Uid */
	private static final long serialVersionUID = 1L;

	/** Stores Logger instance */
	private final Log log = LogFactory.getLog(getClass());

	/** Stores an instance of model data */
	private List<CCFFrequency> data;

	/**
	 * Creates a new instance of FrequencyTableModel
	 * 
	 * @param data model data
	 * @param modelProperties instance of {@link ModelProperties}, defines the
	 *            behaviour and properties of the table model
	 */
	public FrequencyTableModel(List<CCFFrequency> data, ModelProperties modelProperties) {
		super(modelProperties);
		this.data = data;
	}
 
	/* (non-Javadoc)
	 * @see pl.psnc.vlab.util.gui.model.info.TableModelInfo#getModelData()
	 */
	@Override
	public List<CCFFrequency> getModelData() {
		return this.data;
	}

	/**
	 * Get QuantityStockWrapper object for the given row
	 * 
	 * @param row row number
	 * @return QuantityStockWrapper which represents given row
	 */
	@Override
	public CCFFrequency getRowValue(int row) {
		if (row < 0) {
			return null;
		}
		return getRowCount() > row ? data.get(row) : null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return this.data != null ? data.size() : 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int row, int col) {
		return getCellValueAt(row, col);
	}

	// -------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Get value for cell at given row and column index
	 * 
	 * @param row row index
	 * @param column column index
	 * @return cell value
	 */
	private Object getCellValueAt(int row, int column) {
		ColumnInfo columnType = getModelProperties().getColumnType(column);
		if (columnType == null) {
			log.debug("Column type was not found:" + row);
			return null;
		}

		CCFFrequency rowValue = getRowValue(row);
		if (rowValue == null) {
			log.debug("CCFFrequency is NULL");
			return null;
		}

		if (columnType == WfmColumnType.CCF_FREQUENCY) {
			return rowValue.getFrequency();
		}

		if (columnType == WfmColumnType.CCF_BANDWIDTH) {
			return rowValue.getBandwidth();
		}

		if (columnType == WfmColumnType.CCF_SIDEBAND) {
			return rowValue.getSideband();
		}

		if (columnType == WfmColumnType.CCF_POLARISATION) {
			return rowValue.getPolarisation();
		}

		log.error("Cell value not found row=" + row + " col=" + column);
		return null;
	}

}