/*
 * StockArticlesTableModel.java
 *
 */
package pl.psnc.expres.wfm.gui.model.table;

import pl.psnc.vlab.util.gui.model.info.ModelProperties;
import pl.psnc.vlab.util.gui.model.info.TableModelInfo;
import pl.psnc.vlab.util.gui.model.table.AbstractCustomTableModel;

/**
 * {@link CustomMapTableModel} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CustomMapTableModel extends AbstractCustomTableModel implements
		TableModelInfo<String, String[][]> {

	/** Default Serial Uid */
	private static final long serialVersionUID = 1L;

	/** Stores instance of field: dataKeySet */
	private String[][] data;

	/**
	 * Creates a new instance of FrequencyTableModel
	 * 
	 * @param data model data
	 * @param modelProperties instance of {@link ModelProperties}, defines the
	 *            behaviour and properties of the table model
	 */
	public CustomMapTableModel(String[][] data, ModelProperties modelProperties) {
		super(modelProperties);
		this.data = data;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.model.info.TableModelInfo#getModelData()
	 */
	@Override
	public String[][] getModelData() {
		return this.data;
	}

	/**
	 * Get QuantityStockWrapper object for the given row
	 * 
	 * @param row row number
	 * @return QuantityStockWrapper which represents given row
	 */
	@Override
	public String getRowValue(int row) {
		if (row < 0) {
			return null;
		}
		return getRowCount() > row ? data[row][1] : null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return this.data != null ? data.length : 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int row, int col) {
		return getCellValueAt(row, col);
	}

	// -------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Get value for cell at given row and column index
	 * 
	 * @param row row index
	 * @param column column index
	 * @return cell value
	 */
	private Object getCellValueAt(int row, int column) {
		return data[row][column];
	}

}