/*
 * Created by JFormDesigner on Wed Feb 06 13:58:05 CET 2008
 */

package pl.psnc.expres.wfm.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.WindowConstants;
import javax.swing.border.LineBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmActionHelper;
import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.expres.wfm.action.perspective.ResInfPerspAction;
import pl.psnc.expres.wfm.exception.WfmException;
import pl.psnc.expres.wfm.gui.about.SplashDialog;
import pl.psnc.expres.wfm.gui.factory.PaneFactory;
import pl.psnc.expres.wfm.gui.perspective.JWelcomePane;
import pl.psnc.expres.wfm.management.AppInitializer;
import pl.psnc.expres.wfm.management.SplashDialogWorker;
import pl.psnc.expres.wfm.management.WfmConfigurationImpl;
import pl.psnc.expres.wfm.util.Keys;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.vlab.conf.ConfigFactory;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.gui.action.AbstractActionDefault;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.action.helper.ActionHelper;
import pl.psnc.vlab.util.gui.frame.JGenericPane;
import pl.psnc.vlab.util.gui.message.JMessage;
import pl.psnc.vlab.util.gui.progress.JStatusBar;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * {@link JMainFrame} class - application main frame
 * 
 * @author Dominik Stoklosa
 * @email d.stoklosa@man.poznan.pl
 */
/**
 * {@link JMainFrame} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JMainFrame extends JFrame {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Stores log instance */
	private static Log log = LogFactory.getLog(JMainFrame.class.getClass());

	/** Stores instance of configuration key */
	private final static String CFG_FILE = "/wfmConf.properties";

	/** Stores instance of active pane */
	private JPanel activePane;

	/** Instance of main frame */
	private static JMainFrame instance;

	/**
	 * Creates a new instance of JMainFrame
	 */
	public JMainFrame() {
		initComponents();
		this.activePane = JWelcomePane.getInstance();
		// addMainContentPane(JWelcomePane.class, false);
	}

	/**
	 * Handles action event
	 * 
	 * @param e instance of {@link WindowEvent}
	 */
	private void exitForm(WindowEvent e) {
		try {
			ActionFactory.getAction(WfmActionType.APP_EXIT).actionPerformed(null);
		} catch (Exception err) {
			log.error(err.getMessage());
			JMessage.showErrorMessage(this, err.getLocalizedMessage());
		}
	}

	/**
	 * Initialises form components
	 */
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.gui");
		menuBar = new JMenuBar();
		jFileMenu = new JMenu();

		jNewMenuItem = new JMenuItem();
		jOpenMenuItem = new JMenuItem();
		jCloseMenuItem = new JMenuItem();
		jSeparator4 = new JSeparator();
		jSaveMenuItem = new JMenuItem();
		jSaveAsMenuItem = new JMenuItem();
		jSeparator3 = new JSeparator();
		jExitMenuItem = new JMenuItem();
		jEditMenu = new JMenu();
		jUndoMenuItem = new JMenuItem();
		jRedoMenuItem = new JMenuItem();
		jSeparator2 = new JSeparator();
		jCopyMenuItem = new JMenuItem();
		jPasteMenuItem = new JMenuItem();
		jDeleteMenuItem = new JMenuItem();
		jScenarioMenu = new JMenu();
		jSubmitScenarioItem = new JMenuItem();
		jSeparator6 = new JSeparator();
		jScenPropertiesItem = new JMenuItem();
		jViewMenu = new JMenu();
		jActualSizeMenuItem = new JMenuItem();
		jZoomInMenuItem = new JMenuItem();
		jZoomOutMenuItem = new JMenuItem();
		jSeparator12 = new JSeparator();
		jResourceInfoMenuItem = new JCheckBoxMenuItem();
		jActionInfoMenuItem = new JCheckBoxMenuItem();
		jLogMessageMenuItem = new JCheckBoxMenuItem();
		jSeparator13 = new JSeparator();
		jWelcomePaneMenuItem = new JMenuItem();
		jHelpMenu = new JMenu();
		jMenuToolbar = new JToolBar();
		jSeparatorPane11 = new JPanel();
		jNewTb = new JButton();
		jOpenTb = new JButton();
		jSaveTb = new JButton();
		jSaveAsTb = new JButton();
		jSeparatorPane10 = new JPanel();
		jSeparator1 = new JSeparator();
		jSeparatorPane8 = new JPanel();
		jCopyBtn = new JButton();
		jPasteBtn = new JButton();
		jDeleteBtn = new JButton();
		jSeparatorPane7 = new JPanel();
		jSeparator10 = new JSeparator();
		jSeparatorPane9 = new JPanel();
		jUndoBtn = new JButton();
		jRedoBtn = new JButton();
		jSeparatorPane5 = new JPanel();
		jSeparator8 = new JSeparator();
		jSeparatorPane = new JPanel();
		jSubmitBtn = new JButton();
		jSeparatorPane1 = new JPanel();
		jSeparator5 = new JSeparator();
		jSeparatorPane4 = new JPanel();
		jSeparatorPane6 = new JPanel();
		jSeparatorPane2 = new JPanel();
		jZoomActualSizeBtn = new JButton();
		jZoomInBtn = new JButton();
		jZoomOutBtn = new JButton();
		jSeparatorPane3 = new JPanel();
		jMainPane = new JPanel();
		jHeaderPane = new JGenericPane();
		jHeaderAppNameLbl = new JLabel();
		jHeaderIconLbl = new JLabel();
		jPerspectiveSwitch = new SimpleInternalFrame();
		jCPane = new JGenericPane();
		jWorkflowEditorTBtn = new JToggleButton();
		jCcfEditorTBtn = new JToggleButton();
		separator3 = new JSeparator();
		jResourceInfoTBtn = new JToggleButton();
		jLogMessageTBtn = new JToggleButton();
		jContentPane = new JPanel();
		jWelcomePane = JWelcomePane.getInstance();
		jStatusBar = new JStatusBar();
		CellConstraints cc = new CellConstraints();

		//======== this ========
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		setName("this");
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				exitForm(e);
			}
		});
		Container contentPane = getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));

		//======== menuBar ========
		{
			menuBar.setMaximumSize(new Dimension(2000, 30));
			menuBar.setMinimumSize(new Dimension(100, 30));
			menuBar.setPreferredSize(new Dimension(600, 25));
			menuBar.setName("menuBar");


			//======== jFileMenu ========
			{
				jFileMenu.setMnemonic('f');
				jFileMenu.setText(bundle.getString("main.frame.jFileMenu.text"));
				jFileMenu.setToolTipText(bundle.getString("main.frame.jFileMenu.toolTipText"));
				jFileMenu.setName("jFileMenu");

				//---- jNewMenuItem ----
				jNewMenuItem.setIconTextGap(0);
				jNewMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jNewMenuItem.setName("jNewMenuItem");
				jFileMenu.add(jNewMenuItem);

				//---- jOpenMenuItem ----
				jOpenMenuItem.setIconTextGap(0);
				jOpenMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jOpenMenuItem.setName("jOpenMenuItem");
				jFileMenu.add(jOpenMenuItem);

				//---- jCloseMenuItem ----
				jCloseMenuItem.setIconTextGap(0);
				jCloseMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jCloseMenuItem.setName("jCloseMenuItem");
				jFileMenu.add(jCloseMenuItem);

				//---- jSeparator4 ----
				jSeparator4.setName("jSeparator4");
				jFileMenu.add(jSeparator4);

				//---- jSaveMenuItem ----
				jSaveMenuItem.setIconTextGap(0);
				jSaveMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jSaveMenuItem.setName("jSaveMenuItem");
				jFileMenu.add(jSaveMenuItem);

				//---- jSaveAsMenuItem ----
				jSaveAsMenuItem.setIconTextGap(0);
				jSaveAsMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jSaveAsMenuItem.setName("jSaveAsMenuItem");
				jFileMenu.add(jSaveAsMenuItem);

				//---- jSeparator3 ----
				jSeparator3.setName("jSeparator3");
				jFileMenu.add(jSeparator3);

				//---- jExitMenuItem ----
				jExitMenuItem.setAlignmentY(1.5F);
				jExitMenuItem.setIconTextGap(0);
				jExitMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jExitMenuItem.setName("jExitMenuItem");
				jFileMenu.add(jExitMenuItem);
			}
			menuBar.add(jFileMenu);

			//======== jEditMenu ========
			{
				jEditMenu.setMnemonic('e');
				jEditMenu.setText(bundle.getString("main.frame.jEditMenu.text"));
				jEditMenu.setToolTipText(bundle.getString("main.frame.jEditMenu.toolTipText"));
				jEditMenu.setAlignmentX(2.0F);
				jEditMenu.setMargin(new Insets(2, 4, 2, 2));
				jEditMenu.setName("jEditMenu");

				//---- jUndoMenuItem ----
				jUndoMenuItem.setAlignmentX(2.0F);
				jUndoMenuItem.setMargin(new Insets(4, 2, 2, 4));
				jUndoMenuItem.setName("jUndoMenuItem");
				jEditMenu.add(jUndoMenuItem);

				//---- jRedoMenuItem ----
				jRedoMenuItem.setAlignmentX(2.0F);
				jRedoMenuItem.setMargin(new Insets(4, 2, 2, 4));
				jRedoMenuItem.setName("jRedoMenuItem");
				jEditMenu.add(jRedoMenuItem);

				//---- jSeparator2 ----
				jSeparator2.setAlignmentX(2.0F);
				jSeparator2.setName("jSeparator2");
				jEditMenu.add(jSeparator2);

				//---- jCopyMenuItem ----
				jCopyMenuItem.setAlignmentX(2.0F);
				jCopyMenuItem.setMargin(new Insets(4, 2, 2, 4));
				jCopyMenuItem.setName("jCopyMenuItem");
				jEditMenu.add(jCopyMenuItem);

				//---- jPasteMenuItem ----
				jPasteMenuItem.setAlignmentX(2.0F);
				jPasteMenuItem.setMargin(new Insets(4, 2, 2, 4));
				jPasteMenuItem.setName("jPasteMenuItem");
				jEditMenu.add(jPasteMenuItem);

				//---- jDeleteMenuItem ----
				jDeleteMenuItem.setAlignmentX(2.0F);
				jDeleteMenuItem.setMargin(new Insets(4, 2, 2, 4));
				jDeleteMenuItem.setName("jDeleteMenuItem");
				jEditMenu.add(jDeleteMenuItem);
			}
			menuBar.add(jEditMenu);

			//======== jScenarioMenu ========
			{
				jScenarioMenu.setMnemonic('s');
				jScenarioMenu.setText(bundle.getString("main.frame.jScenarioMenu.text"));
				jScenarioMenu.setName("jScenarioMenu");

				//---- jSubmitScenarioItem ----
				jSubmitScenarioItem.setIconTextGap(0);
				jSubmitScenarioItem.setMargin(new Insets(4, 2, 4, 2));
				jSubmitScenarioItem.setName("jSubmitScenarioItem");
				jScenarioMenu.add(jSubmitScenarioItem);

				//---- jSeparator6 ----
				jSeparator6.setName("jSeparator6");
				jScenarioMenu.add(jSeparator6);

				//---- jScenPropertiesItem ----
				jScenPropertiesItem.setMargin(new Insets(4, 2, 4, 2));
				jScenPropertiesItem.setName("jScenPropertiesItem");
				jScenarioMenu.add(jScenPropertiesItem);
			}
			menuBar.add(jScenarioMenu);

			//======== jViewMenu ========
			{
				jViewMenu.setMnemonic('v');
				jViewMenu.setText(bundle.getString("main.frame.jViewMenu.text"));
				jViewMenu.setToolTipText(bundle.getString("main.frame.jViewMenu.toolTipText"));
				jViewMenu.setName("jViewMenu");

				//---- jActualSizeMenuItem ----
				jActualSizeMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jActualSizeMenuItem.setName("jActualSizeMenuItem");
				jViewMenu.add(jActualSizeMenuItem);

				//---- jZoomInMenuItem ----
				jZoomInMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jZoomInMenuItem.setName("jZoomInMenuItem");
				jViewMenu.add(jZoomInMenuItem);

				//---- jZoomOutMenuItem ----
				jZoomOutMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jZoomOutMenuItem.setName("jZoomOutMenuItem");
				jViewMenu.add(jZoomOutMenuItem);

				//---- jSeparator12 ----
				jSeparator12.setName("jSeparator12");
				jViewMenu.add(jSeparator12);

				//---- jResourceInfoMenuItem ----
				jResourceInfoMenuItem.setText("CheckBox");
				jResourceInfoMenuItem.setName("jResourceInfoMenuItem");
				jViewMenu.add(jResourceInfoMenuItem);

				//---- jActionInfoMenuItem ----
				jActionInfoMenuItem.setText("CheckBox");
				jActionInfoMenuItem.setName("jActionInfoMenuItem");
				jViewMenu.add(jActionInfoMenuItem);

				//---- jLogMessageMenuItem ----
				jLogMessageMenuItem.setText("CheckBox");
				jLogMessageMenuItem.setName("jLogMessageMenuItem");
				jViewMenu.add(jLogMessageMenuItem);

				//---- jSeparator13 ----
				jSeparator13.setName("jSeparator13");
				jViewMenu.add(jSeparator13);

				//---- jWelcomePaneMenuItem ----
				jWelcomePaneMenuItem.setMargin(new Insets(4, 2, 4, 2));
				jWelcomePaneMenuItem.setName("jWelcomePaneMenuItem");
				jViewMenu.add(jWelcomePaneMenuItem);
			}
			menuBar.add(jViewMenu);

			//======== jHelpMenu ========
			{
				jHelpMenu.setMnemonic('H');
				jHelpMenu.setText(bundle.getString("main.frame.jHelpMenu.text"));
				jHelpMenu.setToolTipText(bundle.getString("main.frame.jHelpMenu.toolTipText"));
				jHelpMenu.setName("jHelpMenu");
			}
			menuBar.add(jHelpMenu);
		}
		setJMenuBar(menuBar);

		//======== jMenuToolbar ========
		{
			jMenuToolbar.setEnabled(false);
			jMenuToolbar.setMaximumSize(new Dimension(2000, 33));
			jMenuToolbar.setMinimumSize(new Dimension(100, 33));
			jMenuToolbar.setPreferredSize(new Dimension(600, 33));
			jMenuToolbar.setName("jMenuToolbar");

			//======== jSeparatorPane11 ========
			{
				jSeparatorPane11.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane11.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane11.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane11.setName("jSeparatorPane11");
				jSeparatorPane11.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane11);

			//---- jNewTb ----
			jNewTb.setFocusPainted(false);
			jNewTb.setFocusable(false);
			jNewTb.setHorizontalTextPosition(SwingConstants.CENTER);
			jNewTb.setMargin(new Insets(2, 5, 2, 5));
			jNewTb.setMaximumSize(new Dimension(25, 25));
			jNewTb.setMinimumSize(new Dimension(25, 25));
			jNewTb.setPreferredSize(new Dimension(25, 25));
			jNewTb.setRequestFocusEnabled(false);
			jNewTb.setBorderPainted(false);
			jNewTb.setName("jNewTb");
			jMenuToolbar.add(jNewTb);

			//---- jOpenTb ----
			jOpenTb.setFocusPainted(false);
			jOpenTb.setFocusable(false);
			jOpenTb.setHorizontalTextPosition(SwingConstants.CENTER);
			jOpenTb.setMargin(new Insets(2, 5, 2, 5));
			jOpenTb.setMaximumSize(new Dimension(25, 25));
			jOpenTb.setMinimumSize(new Dimension(25, 25));
			jOpenTb.setPreferredSize(new Dimension(25, 25));
			jOpenTb.setRequestFocusEnabled(false);
			jOpenTb.setBorderPainted(false);
			jOpenTb.setName("jOpenTb");
			jMenuToolbar.add(jOpenTb);

			//---- jSaveTb ----
			jSaveTb.setFocusPainted(false);
			jSaveTb.setFocusable(false);
			jSaveTb.setHorizontalTextPosition(SwingConstants.CENTER);
			jSaveTb.setMargin(new Insets(2, 5, 2, 5));
			jSaveTb.setMaximumSize(new Dimension(25, 25));
			jSaveTb.setMinimumSize(new Dimension(25, 25));
			jSaveTb.setPreferredSize(new Dimension(25, 25));
			jSaveTb.setRequestFocusEnabled(false);
			jSaveTb.setBorderPainted(false);
			jSaveTb.setName("jSaveTb");
			jMenuToolbar.add(jSaveTb);

			//---- jSaveAsTb ----
			jSaveAsTb.setFocusPainted(false);
			jSaveAsTb.setFocusable(false);
			jSaveAsTb.setHorizontalTextPosition(SwingConstants.CENTER);
			jSaveAsTb.setMargin(new Insets(2, 5, 2, 5));
			jSaveAsTb.setMaximumSize(new Dimension(25, 25));
			jSaveAsTb.setMinimumSize(new Dimension(25, 25));
			jSaveAsTb.setPreferredSize(new Dimension(25, 25));
			jSaveAsTb.setRequestFocusEnabled(false);
			jSaveAsTb.setBorderPainted(false);
			jSaveAsTb.setName("jSaveAsTb");
			jMenuToolbar.add(jSaveAsTb);

			//======== jSeparatorPane10 ========
			{
				jSeparatorPane10.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane10.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane10.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane10.setName("jSeparatorPane10");
				jSeparatorPane10.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane10);

			//---- jSeparator1 ----
			jSeparator1.setOrientation(SwingConstants.VERTICAL);
			jSeparator1.setEnabled(false);
			jSeparator1.setMaximumSize(new Dimension(2, 20));
			jSeparator1.setPreferredSize(new Dimension(2, 20));
			jSeparator1.setRequestFocusEnabled(false);
			jSeparator1.setName("jSeparator1");
			jMenuToolbar.add(jSeparator1);

			//======== jSeparatorPane8 ========
			{
				jSeparatorPane8.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane8.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane8.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane8.setName("jSeparatorPane8");
				jSeparatorPane8.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane8);

			//---- jCopyBtn ----
			jCopyBtn.setEnabled(false);
			jCopyBtn.setFocusPainted(false);
			jCopyBtn.setFocusable(false);
			jCopyBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jCopyBtn.setMargin(new Insets(2, 5, 2, 5));
			jCopyBtn.setMaximumSize(new Dimension(25, 25));
			jCopyBtn.setMinimumSize(new Dimension(25, 25));
			jCopyBtn.setPreferredSize(new Dimension(25, 25));
			jCopyBtn.setRequestFocusEnabled(false);
			jCopyBtn.setBorderPainted(false);
			jCopyBtn.setName("jCopyBtn");
			jMenuToolbar.add(jCopyBtn);

			//---- jPasteBtn ----
			jPasteBtn.setEnabled(false);
			jPasteBtn.setFocusPainted(false);
			jPasteBtn.setFocusable(false);
			jPasteBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jPasteBtn.setMargin(new Insets(2, 5, 2, 5));
			jPasteBtn.setMaximumSize(new Dimension(25, 25));
			jPasteBtn.setMinimumSize(new Dimension(25, 25));
			jPasteBtn.setPreferredSize(new Dimension(25, 25));
			jPasteBtn.setRequestFocusEnabled(false);
			jPasteBtn.setBorderPainted(false);
			jPasteBtn.setName("jPasteBtn");
			jMenuToolbar.add(jPasteBtn);

			//---- jDeleteBtn ----
			jDeleteBtn.setEnabled(false);
			jDeleteBtn.setFocusPainted(false);
			jDeleteBtn.setFocusable(false);
			jDeleteBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jDeleteBtn.setMargin(new Insets(2, 5, 2, 5));
			jDeleteBtn.setMaximumSize(new Dimension(25, 25));
			jDeleteBtn.setMinimumSize(new Dimension(25, 25));
			jDeleteBtn.setPreferredSize(new Dimension(25, 25));
			jDeleteBtn.setRequestFocusEnabled(false);
			jDeleteBtn.setBorderPainted(false);
			jDeleteBtn.setName("jDeleteBtn");
			jMenuToolbar.add(jDeleteBtn);

			//======== jSeparatorPane7 ========
			{
				jSeparatorPane7.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane7.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane7.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane7.setName("jSeparatorPane7");
				jSeparatorPane7.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane7);

			//---- jSeparator10 ----
			jSeparator10.setOrientation(SwingConstants.VERTICAL);
			jSeparator10.setEnabled(false);
			jSeparator10.setMaximumSize(new Dimension(2, 20));
			jSeparator10.setPreferredSize(new Dimension(2, 20));
			jSeparator10.setRequestFocusEnabled(false);
			jSeparator10.setName("jSeparator10");
			jMenuToolbar.add(jSeparator10);

			//======== jSeparatorPane9 ========
			{
				jSeparatorPane9.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane9.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane9.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane9.setName("jSeparatorPane9");
				jSeparatorPane9.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane9);

			//---- jUndoBtn ----
			jUndoBtn.setEnabled(false);
			jUndoBtn.setFocusPainted(false);
			jUndoBtn.setFocusable(false);
			jUndoBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jUndoBtn.setMargin(new Insets(2, 5, 2, 5));
			jUndoBtn.setMaximumSize(new Dimension(25, 25));
			jUndoBtn.setMinimumSize(new Dimension(25, 25));
			jUndoBtn.setPreferredSize(new Dimension(25, 25));
			jUndoBtn.setRequestFocusEnabled(false);
			jUndoBtn.setBorderPainted(false);
			jUndoBtn.setName("jUndoBtn");
			jMenuToolbar.add(jUndoBtn);

			//---- jRedoBtn ----
			jRedoBtn.setEnabled(false);
			jRedoBtn.setFocusPainted(false);
			jRedoBtn.setFocusable(false);
			jRedoBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jRedoBtn.setMargin(new Insets(2, 5, 2, 5));
			jRedoBtn.setMaximumSize(new Dimension(25, 25));
			jRedoBtn.setMinimumSize(new Dimension(25, 25));
			jRedoBtn.setPreferredSize(new Dimension(25, 25));
			jRedoBtn.setRequestFocusEnabled(false);
			jRedoBtn.setBorderPainted(false);
			jRedoBtn.setName("jRedoBtn");
			jMenuToolbar.add(jRedoBtn);

			//======== jSeparatorPane5 ========
			{
				jSeparatorPane5.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane5.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane5.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane5.setName("jSeparatorPane5");
				jSeparatorPane5.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane5);

			//---- jSeparator8 ----
			jSeparator8.setOrientation(SwingConstants.VERTICAL);
			jSeparator8.setEnabled(false);
			jSeparator8.setMaximumSize(new Dimension(2, 20));
			jSeparator8.setPreferredSize(new Dimension(2, 20));
			jSeparator8.setRequestFocusEnabled(false);
			jSeparator8.setName("jSeparator8");
			jMenuToolbar.add(jSeparator8);

			//======== jSeparatorPane ========
			{
				jSeparatorPane.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane.setName("jSeparatorPane");
				jSeparatorPane.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane);

			//---- jSubmitBtn ----
			jSubmitBtn.setFocusPainted(false);
			jSubmitBtn.setFocusable(false);
			jSubmitBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jSubmitBtn.setMargin(new Insets(0, 0, 0, 0));
			jSubmitBtn.setMaximumSize(new Dimension(25, 25));
			jSubmitBtn.setMinimumSize(new Dimension(25, 25));
			jSubmitBtn.setPreferredSize(new Dimension(25, 25));
			jSubmitBtn.setRequestFocusEnabled(false);
			jSubmitBtn.setBorderPainted(false);
			jSubmitBtn.setName("jSubmitBtn");
			jMenuToolbar.add(jSubmitBtn);

			//======== jSeparatorPane1 ========
			{
				jSeparatorPane1.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane1.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane1.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane1.setName("jSeparatorPane1");
				jSeparatorPane1.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane1);

			//---- jSeparator5 ----
			jSeparator5.setOrientation(SwingConstants.VERTICAL);
			jSeparator5.setEnabled(false);
			jSeparator5.setMaximumSize(new Dimension(2, 20));
			jSeparator5.setPreferredSize(new Dimension(2, 20));
			jSeparator5.setRequestFocusEnabled(false);
			jSeparator5.setName("jSeparator5");
			jMenuToolbar.add(jSeparator5);

			//======== jSeparatorPane4 ========
			{
				jSeparatorPane4.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane4.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane4.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane4.setName("jSeparatorPane4");
				jSeparatorPane4.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane4);

			//======== jSeparatorPane6 ========
			{
				jSeparatorPane6.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane6.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane6.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane6.setName("jSeparatorPane6");
				jSeparatorPane6.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane6);

			//======== jSeparatorPane2 ========
			{
				jSeparatorPane2.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane2.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane2.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane2.setName("jSeparatorPane2");
				jSeparatorPane2.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane2);

			//---- jZoomActualSizeBtn ----
			jZoomActualSizeBtn.setEnabled(false);
			jZoomActualSizeBtn.setFocusPainted(false);
			jZoomActualSizeBtn.setFocusable(false);
			jZoomActualSizeBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jZoomActualSizeBtn.setMargin(new Insets(2, 5, 2, 5));
			jZoomActualSizeBtn.setMaximumSize(new Dimension(25, 25));
			jZoomActualSizeBtn.setMinimumSize(new Dimension(25, 25));
			jZoomActualSizeBtn.setPreferredSize(new Dimension(25, 25));
			jZoomActualSizeBtn.setRequestFocusEnabled(false);
			jZoomActualSizeBtn.setBorderPainted(false);
			jZoomActualSizeBtn.setName("jZoomActualSizeBtn");
			jMenuToolbar.add(jZoomActualSizeBtn);

			//---- jZoomInBtn ----
			jZoomInBtn.setEnabled(false);
			jZoomInBtn.setFocusPainted(false);
			jZoomInBtn.setFocusable(false);
			jZoomInBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jZoomInBtn.setMargin(new Insets(2, 5, 2, 5));
			jZoomInBtn.setMaximumSize(new Dimension(25, 25));
			jZoomInBtn.setMinimumSize(new Dimension(25, 25));
			jZoomInBtn.setPreferredSize(new Dimension(25, 25));
			jZoomInBtn.setRequestFocusEnabled(false);
			jZoomInBtn.setBorderPainted(false);
			jZoomInBtn.setName("jZoomInBtn");
			jMenuToolbar.add(jZoomInBtn);

			//---- jZoomOutBtn ----
			jZoomOutBtn.setEnabled(false);
			jZoomOutBtn.setFocusPainted(false);
			jZoomOutBtn.setFocusable(false);
			jZoomOutBtn.setHorizontalTextPosition(SwingConstants.CENTER);
			jZoomOutBtn.setMargin(new Insets(2, 5, 2, 5));
			jZoomOutBtn.setMaximumSize(new Dimension(25, 25));
			jZoomOutBtn.setMinimumSize(new Dimension(25, 25));
			jZoomOutBtn.setPreferredSize(new Dimension(25, 25));
			jZoomOutBtn.setRequestFocusEnabled(false);
			jZoomOutBtn.setBorderPainted(false);
			jZoomOutBtn.setName("jZoomOutBtn");
			jMenuToolbar.add(jZoomOutBtn);

			//======== jSeparatorPane3 ========
			{
				jSeparatorPane3.setMaximumSize(new Dimension(5, 5));
				jSeparatorPane3.setMinimumSize(new Dimension(5, 5));
				jSeparatorPane3.setPreferredSize(new Dimension(5, 5));
				jSeparatorPane3.setName("jSeparatorPane3");
				jSeparatorPane3.setLayout(new FlowLayout());
			}
			jMenuToolbar.add(jSeparatorPane3);
		}
		contentPane.add(jMenuToolbar);

		//======== jMainPane ========
		{
			jMainPane.setName("jMainPane");

			//======== jHeaderPane ========
			{
				jHeaderPane.setBorder(new LineBorder(Color.lightGray));
				jHeaderPane.setForeground(Color.lightGray);
				jHeaderPane.setName("jHeaderPane");

				//---- jHeaderAppNameLbl ----
				jHeaderAppNameLbl.setIcon(new ImageIcon(getClass().getResource("/images/logo/tmpBanner-text1.png")));
				jHeaderAppNameLbl.setName("jHeaderAppNameLbl");

				//---- jHeaderIconLbl ----
				jHeaderIconLbl.setIcon(new ImageIcon(getClass().getResource("/images/logo/tmpBanner-radiotelescopes.png")));
				jHeaderIconLbl.setName("jHeaderIconLbl");

				PanelBuilder jHeaderPaneBuilder = new PanelBuilder(new FormLayout(
					"default, default:grow, default",
					"fill:default:grow"), jHeaderPane);

				jHeaderPaneBuilder.add(jHeaderAppNameLbl, cc.xy(1, 1));
				jHeaderPaneBuilder.add(jHeaderIconLbl,    cc.xy(3, 1));
			}

			//======== jPerspectiveSwitch ========
			{
				jPerspectiveSwitch.setMaximumSize(new Dimension(30, 32767));
				jPerspectiveSwitch.setMinimumSize(new Dimension(25, 30));
				jPerspectiveSwitch.setTitle(" ");
				jPerspectiveSwitch.setFrameIcon(new ImageIcon(getClass().getResource("/images/eclipse/perspective/export_brkpts.gif")));
				jPerspectiveSwitch.setName("jPerspectiveSwitch");
				Container jPerspectiveSwitchContentPane = jPerspectiveSwitch.getContentPane();

				//======== jCPane ========
				{
					jCPane.setMinimumSize(new Dimension(33, 85));
					jCPane.setName("jCPane");

					//---- jWorkflowEditorTBtn ----
					jWorkflowEditorTBtn.setFocusable(false);
					jWorkflowEditorTBtn.setMaximumSize(new Dimension(20, 20));
					jWorkflowEditorTBtn.setMinimumSize(new Dimension(20, 20));
					jWorkflowEditorTBtn.setPreferredSize(new Dimension(20, 20));
					jWorkflowEditorTBtn.setHorizontalTextPosition(SwingConstants.CENTER);
					jWorkflowEditorTBtn.setMargin(new Insets(0, 0, 0, 0));
					jWorkflowEditorTBtn.setIconTextGap(0);
					jWorkflowEditorTBtn.setHorizontalAlignment(SwingConstants.RIGHT);
					jWorkflowEditorTBtn.setOpaque(false);
					jWorkflowEditorTBtn.setBorderPainted(false);
					jWorkflowEditorTBtn.setName("jWorkflowEditorTBtn");

					//---- jCcfEditorTBtn ----
					jCcfEditorTBtn.setFocusable(false);
					jCcfEditorTBtn.setMaximumSize(new Dimension(20, 20));
					jCcfEditorTBtn.setMinimumSize(new Dimension(20, 20));
					jCcfEditorTBtn.setPreferredSize(new Dimension(20, 20));
					jCcfEditorTBtn.setBorderPainted(false);
					jCcfEditorTBtn.setOpaque(false);
					jCcfEditorTBtn.setName("jCcfEditorTBtn");

					//---- separator3 ----
					separator3.setName("separator3");

					//---- jResourceInfoTBtn ----
					jResourceInfoTBtn.setFocusable(false);
					jResourceInfoTBtn.setMaximumSize(new Dimension(20, 20));
					jResourceInfoTBtn.setMinimumSize(new Dimension(20, 20));
					jResourceInfoTBtn.setPreferredSize(new Dimension(20, 20));
					jResourceInfoTBtn.setBorderPainted(false);
					jResourceInfoTBtn.setOpaque(false);
					jResourceInfoTBtn.setName("jResourceInfoTBtn");

					//---- jLogMessageTBtn ----
					jLogMessageTBtn.setFocusable(false);
					jLogMessageTBtn.setMaximumSize(new Dimension(20, 20));
					jLogMessageTBtn.setMinimumSize(new Dimension(20, 20));
					jLogMessageTBtn.setPreferredSize(new Dimension(20, 20));
					jLogMessageTBtn.setBorderPainted(false);
					jLogMessageTBtn.setOpaque(false);
					jLogMessageTBtn.setName("jLogMessageTBtn");

					PanelBuilder jCPaneBuilder = new PanelBuilder(new FormLayout(
						new ColumnSpec[] {
							new ColumnSpec(Sizes.DLUX3),
							new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
							new ColumnSpec(Sizes.DLUX3)
						},
						new RowSpec[] {
							new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW),
							new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.NO_GROW),
							FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC,
							FormFactory.DEFAULT_ROWSPEC,
							FormFactory.LINE_GAP_ROWSPEC,
							new RowSpec(RowSpec.FILL, Sizes.DLUY8, FormSpec.NO_GROW)
						}), jCPane);

					jCPaneBuilder.add(jWorkflowEditorTBtn, cc.xy(2,  2));
					jCPaneBuilder.add(jCcfEditorTBtn,      cc.xy(2,  4));
					jCPaneBuilder.add(separator3,          cc.xy(2,  6));
					jCPaneBuilder.add(jResourceInfoTBtn,   cc.xy(2,  8));
					jCPaneBuilder.add(jLogMessageTBtn,     cc.xy(2, 10));
				}

				PanelBuilder jPerspectiveSwitchContentPaneBuilder = new PanelBuilder(new FormLayout(
					"default:grow",
					"fill:default:grow"));
				jPerspectiveSwitchContentPane.setLayout(new BorderLayout());
				jPerspectiveSwitchContentPane.add(jPerspectiveSwitchContentPaneBuilder.getPanel(), BorderLayout.CENTER);

				jPerspectiveSwitchContentPaneBuilder.add(jCPane, cc.xy(1, 1));
			}

			//======== jContentPane ========
			{
				jContentPane.setName("jContentPane");

				//---- jWelcomePane ----
				jWelcomePane.setName("jWelcomePane");

				PanelBuilder jContentPaneBuilder = new PanelBuilder(new FormLayout(
					"default:grow",
					"fill:default:grow"), jContentPane);

				jContentPaneBuilder.add(jWelcomePane, cc.xy(1, 1));
			}

			//---- jStatusBar ----
			jStatusBar.setMaximumSize(new Dimension(32767, 20));
			jStatusBar.setMinimumSize(new Dimension(100, 20));
			jStatusBar.setPreferredSize(new Dimension(600, 20));
			jStatusBar.setOpaque(false);
			jStatusBar.setName("jStatusBar");

			PanelBuilder jMainPaneBuilder = new PanelBuilder(new FormLayout(
				new ColumnSpec[] {
					FormFactory.DEFAULT_COLSPEC,
					new ColumnSpec(Sizes.DLUX3),
					new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW)
				},
				new RowSpec[] {
					new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.NO_GROW),
					FormFactory.LINE_GAP_ROWSPEC,
					new RowSpec(RowSpec.FILL, Sizes.DEFAULT, FormSpec.DEFAULT_GROW),
					FormFactory.LINE_GAP_ROWSPEC,
					FormFactory.DEFAULT_ROWSPEC
				}), jMainPane);

			jMainPaneBuilder.add(jHeaderPane,        cc.xywh(1, 1, 3, 1));
			jMainPaneBuilder.add(jPerspectiveSwitch, cc.xy  (1, 3));
			jMainPaneBuilder.add(jContentPane,       cc.xy  (3, 3));
			jMainPaneBuilder.add(jStatusBar,         cc.xywh(1, 5, 3, 1));
		}
		contentPane.add(jMainPane);
		setSize(1150, 770);
		setLocationRelativeTo(null);

		//---- buttonGroup1 ----
		ButtonGroup buttonGroup1 = new ButtonGroup();
		buttonGroup1.add(jWorkflowEditorTBtn);
		buttonGroup1.add(jCcfEditorTBtn);
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JMenuBar menuBar;
	private JMenu jFileMenu;
	private JMenuItem jNewMenuItem;
	private JMenuItem jOpenMenuItem;
	private JMenuItem jCloseMenuItem;
	private JSeparator jSeparator4;
	private JMenuItem jSaveMenuItem;
	private JMenuItem jSaveAsMenuItem;
	private JSeparator jSeparator3;
	private JMenuItem jExitMenuItem;
	private JMenu jEditMenu;
	private JMenuItem jUndoMenuItem;
	private JMenuItem jRedoMenuItem;
	private JSeparator jSeparator2;
	private JMenuItem jCopyMenuItem;
	private JMenuItem jPasteMenuItem;
	private JMenuItem jDeleteMenuItem;
	private JMenu jScenarioMenu;
	private JMenuItem jSubmitScenarioItem;
	private JSeparator jSeparator6;
	private JMenuItem jScenPropertiesItem;
	private JMenu jViewMenu;
	private JMenuItem jActualSizeMenuItem;
	private JMenuItem jZoomInMenuItem;
	private JMenuItem jZoomOutMenuItem;
	private JSeparator jSeparator12;
	private JCheckBoxMenuItem jResourceInfoMenuItem;
	private JCheckBoxMenuItem jActionInfoMenuItem;
	private JCheckBoxMenuItem jLogMessageMenuItem;
	private JSeparator jSeparator13;
	private JMenuItem jWelcomePaneMenuItem;
	private JMenu jHelpMenu;
	private JToolBar jMenuToolbar;
	private JPanel jSeparatorPane11;
	private JButton jNewTb;
	private JButton jOpenTb;
	private JButton jSaveTb;
	private JButton jSaveAsTb;
	private JPanel jSeparatorPane10;
	private JSeparator jSeparator1;
	private JPanel jSeparatorPane8;
	private JButton jCopyBtn;
	private JButton jPasteBtn;
	private JButton jDeleteBtn;
	private JPanel jSeparatorPane7;
	private JSeparator jSeparator10;
	private JPanel jSeparatorPane9;
	private JButton jUndoBtn;
	private JButton jRedoBtn;
	private JPanel jSeparatorPane5;
	private JSeparator jSeparator8;
	private JPanel jSeparatorPane;
	private JButton jSubmitBtn;
	private JPanel jSeparatorPane1;
	private JSeparator jSeparator5;
	private JPanel jSeparatorPane4;
	private JPanel jSeparatorPane6;
	private JPanel jSeparatorPane2;
	private JButton jZoomActualSizeBtn;
	private JButton jZoomInBtn;
	private JButton jZoomOutBtn;
	private JPanel jSeparatorPane3;
	private JPanel jMainPane;
	private JGenericPane jHeaderPane;
	private JLabel jHeaderAppNameLbl;
	private JLabel jHeaderIconLbl;
	private SimpleInternalFrame jPerspectiveSwitch;
	private JGenericPane jCPane;
	private JToggleButton jWorkflowEditorTBtn;
	private JToggleButton jCcfEditorTBtn;
	private JSeparator separator3;
	private JToggleButton jResourceInfoTBtn;
	private JToggleButton jLogMessageTBtn;
	private JPanel jContentPane;
	private JWelcomePane jWelcomePane;
	private JStatusBar jStatusBar;
	// JFormDesigner - End of variables declaration //GEN-END:variables

	/**
	 * Add new JPanel to the Content Internal Frame
	 * 
	 * @param paneClass JPanel to be added, referred by the {@link Class}
	 * 
	 * @param cache specifies whether panes should be cached
	 */
	public <T extends JPanel> void addMainContentPane(Class<T> paneClass, boolean cache) {
		if (activePane != null && activePane.getClass() == paneClass) {
			log.debug("Already opened");
			return;
		}
		JPanel pane = null;
		if (cache) { // take from cache if true
			pane = PaneFactory.getJPane(paneClass);
		}
		if (pane == null) {
			log.debug("Creating new jPane: " + paneClass.getSimpleName());
			try {
				pane = PaneFactory.newInstance(paneClass);
			} catch (WfmException e) {
				log.error(e.getMessage());
				e.printStackTrace();
				JMessage.showErrorMessage(this, e.getLocalizedMessage());
				return;
			}
			if (cache) { // store if cache is true
				PaneFactory.storeJPane(pane);
			}
		}
		if (activePane != null) {
			log.debug("Removing pane:" + pane.getClass());
			jContentPane.remove(activePane);
		}
		CellConstraints cc = new CellConstraints();
		cc.xy(1, 1);
		// jContentIFrame.setTitle(((JGenericPanel) pane).getFrameTitle());
		jContentPane.add(pane, cc);
		jContentPane.updateUI();
		activePane = pane;
	}

	// --------------------------------------------------------------------------
	// ----- Private helper methods

	/**
	 * Initialise the components actions
	 * 
	 * @throws VlabException thrown when action initialization fails
	 */
	private void initActions() throws ResourceNotFoundException {
		initPerespectiveToolbar();
		initToolbar();
		initMenubar();
	}

	/**
	 * Initialise the application main toolbar
	 * 
	 * @throws VlabException thrown when action initializaion fails
	 */
	private void initToolbar() throws ResourceNotFoundException {
		WfmActionHelper.setAction(jNewTb, WfmActionType.SCENARIO_NEW, true);
		WfmActionHelper.setAction(jOpenTb, WfmActionType.SCENARIO_OPEN, true);
		WfmActionHelper.setAction(jSaveTb, WfmActionType.SCENARIO_SAVE, false);
		WfmActionHelper.setAction(jSaveAsTb, WfmActionType.SCENARIO_SAVE_AS, false);

		// undo / redo
		WfmActionHelper.setAction(jUndoBtn, GraphActionType.UNDO, false);
		WfmActionHelper.setAction(jRedoBtn, GraphActionType.REDO, false);

		// submit scenario
		WfmActionHelper.setAction(jSubmitBtn, WfmActionType.SCENARIO_SUBMIT, false);

	}

	/**
	 * Initialise the application manu bar
	 * 
	 * @throws VlabException thrown when action initializaion fails
	 */
	private void initMenubar() throws ResourceNotFoundException {
		// File menu
		WfmActionHelper.setAction(jNewMenuItem, WfmActionType.SCENARIO_NEW, true);
		WfmActionHelper.setAction(jOpenMenuItem, WfmActionType.SCENARIO_OPEN, true);
		WfmActionHelper.setAction(jCloseMenuItem, WfmActionType.SCENARIO_CLOSE, true);
		WfmActionHelper.setAction(jSaveMenuItem, WfmActionType.SCENARIO_SAVE, false);
		WfmActionHelper.setAction(jSaveAsMenuItem, WfmActionType.SCENARIO_SAVE_AS, false);
		WfmActionHelper.setAction(jCloseMenuItem, WfmActionType.SCENARIO_CLOSE, false);
		WfmActionHelper.setAction(jExitMenuItem, WfmActionType.APP_EXIT, true);

		// Edit menu
		WfmActionHelper.setAction(jUndoMenuItem, GraphActionType.UNDO, false);
		WfmActionHelper.setAction(jRedoMenuItem, GraphActionType.REDO, false);

		WfmActionHelper.setAction(jCopyMenuItem, GraphActionType.COPY, false);
		WfmActionHelper.setAction(jDeleteMenuItem, GraphActionType.DELETE, false);
		WfmActionHelper.setAction(jPasteMenuItem, GraphActionType.PASTE, false);

		// Scenario menu
		WfmActionHelper.setAction(jSubmitScenarioItem, WfmActionType.SCENARIO_SUBMIT, false);
		WfmActionHelper.setAction(jScenPropertiesItem, WfmActionType.SCENARIO_PROPERTIES, false);

		// View menu
		WfmActionHelper.setAction(jActualSizeMenuItem, GraphActionType.ZOOM_ACTUAL_SIZE, false);
		WfmActionHelper.setAction(jZoomInMenuItem, GraphActionType.ZOOM_IN, false);
		WfmActionHelper.setAction(jZoomOutMenuItem, GraphActionType.ZOOM_OUT, false);
		WfmActionHelper.setAction(jResourceInfoMenuItem,
				WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE, false);
		WfmActionHelper.setAction(jLogMessageMenuItem, WfmActionType.PERSPECTIVE_EVENT_LOG, false);
		WfmActionHelper.setAction(jWelcomePaneMenuItem, WfmActionType.PERSPECTIVE_WELCOME, true);
	}

	/**
	 * Initialise the perspective toolbar
	 * 
	 * @throws ResourceNotFoundException thrown when action initializaion fails
	 */
	private void initPerespectiveToolbar() throws ResourceNotFoundException {
		// perspective
		AbstractActionDefault action = new ResInfPerspAction(new Object[] { jResourceInfoTBtn,
				jResourceInfoMenuItem });
		ActionFactory.putAction(WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE, action);
		ActionHelper.setAction(jResourceInfoTBtn, action, false);
		ActionHelper.setAction(jResourceInfoMenuItem, action, false);

		WfmActionHelper.setAction(jCcfEditorTBtn, WfmActionType.PERSPECTIVE_CCF_EDITOR, false);
		WfmActionHelper.setAction(jWorkflowEditorTBtn, WfmActionType.PERSPECTIVE_WORKFLOW_EDITOR,
				false);
		WfmActionHelper.setAction(jLogMessageTBtn, WfmActionType.PERSPECTIVE_EVENT_LOG, true);

		// set action observers
		ActionHelper.addObserver(WfmActionType.PERSPECTIVE_WORKFLOW_EDITOR,
				WfmActionType.PERSPECTIVE_CCF_EDITOR);
		ActionHelper.addObserver(WfmActionType.PERSPECTIVE_CCF_EDITOR,
				WfmActionType.PERSPECTIVE_WORKFLOW_EDITOR);
	}

	/**
	 * Method is called only once - when the application starts. Among other
	 * things it checks whether the session is valid.
	 */
	private void initAppData(final JDialog splash) throws WfmException {
		// start session manager thread
		final AppInitializer appInitialiser = new AppInitializer((SplashDialog) splash);

		ActionListener performer = new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				if (appInitialiser != null && appInitialiser.isDone()) {
					Object o = evt.getSource();
					if (o instanceof Timer) {
						log.debug("Timer instance");
						((Timer) o).stop();
						splash.setVisible(false);
						splash.dispose();
						// TODO impl
						// checkResourceActions();
						setVisible(true);
					} else {
						log.debug("Not Timer instance");
					}
					splash.setVisible(false);
					splash.dispose();
					return;
				}
			}
		};

		Timer initTimer = new Timer(Keys.INIT_APP_DATA_TIMER_DELAY, performer);
		initTimer.start();
		splash.setVisible(true);

	}

	/**
	 * Initialise look and feel
	 * 
	 * @throws UnsupportedLookAndFeelException
	 */
	private static void initLookAndFeel() throws UnsupportedLookAndFeelException {
		UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
		UIManager.put(Options.DEFAULT_ICON_SIZE_KEY, new Dimension(18, 18));
		UIManager.put(Options.NO_CONTENT_BORDER_KEY, Boolean.TRUE);
		UIManager.put(Options.EMBEDDED_TABS_KEY, Boolean.TRUE);
		UIManager.put("is3DEnabled", Boolean.TRUE);
	}

	// --------------------------------------------------------------------------
	// ----- JMainFrame main method

	/**
	 * Application main method
	 * 
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		// create settings dir if it not exist
		// SplashDialog splashDialog = null;
		SplashDialog splashDialog = null;
		try {
			log.debug("<main>");
			// Initialise config file
			ConfigFactory.initConfig(CFG_FILE, new WfmConfigurationImpl(CFG_FILE));
			initLookAndFeel();
			// start splash dialog
			splashDialog = new SplashDialog(null, true);
			new SplashDialogWorker(splashDialog);
			JMainFrame mf = getInstance();
			mf.initActions();
			mf.initAppData(splashDialog);
		} catch (Exception exc) {
			exc.printStackTrace();
			JMessage.showErrorMessage(null, exc.getLocalizedMessage());
			System.exit(-1);
		}
	}

	// --------------------------------------------------------------------------
	// ----- Getters / Setters

	/**
	 * Get instance of {@link JMainFrame} class
	 * 
	 * @return new instance of {@link JMainFrame}
	 */
	public static JMainFrame getInstance() {
		if (instance == null) {
			instance = new JMainFrame();
		}
		return instance;
	}

	/**
	 * Get value of the property: jStatusBar
	 * 
	 * @return the jStatusBar
	 */
	public JStatusBar getJStatusBar() {
		return jStatusBar;
	}

	/**
	 * Get value of field: jCcfEditorTBtn
	 * 
	 * @return the jCcfEditorTBtn
	 */
	public JToggleButton getJCcfEditorTBtn() {
		return jCcfEditorTBtn;
	}

	/**
	 * Get value of field: jWorkflowEditorTBtn
	 * 
	 * @return the jWorkflowEditorTBtn
	 */
	public JToggleButton getJWorkflowEditorTBtn() {
		return jWorkflowEditorTBtn;
	}

}
