/*
 * Created by JFormDesigner on Thu Jan 12 14:42:59 CET 2006
 */

package pl.psnc.expres.wfm.gui.event;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

import pl.psnc.expres.wfm.event.EventLogCellRenderer;
import pl.psnc.expres.wfm.event.EventLogFactory;
import pl.psnc.expres.wfm.event.EventLogTableModel;
import pl.psnc.expres.wfm.management.SystemConfigurationFactory;
import pl.psnc.vlab.util.i18n.ResourceBundleManager;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;

/**
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class MsgEventPane extends SimpleInternalFrame {

	/** Stores an instance of Main Frame Base */
	private JPanel mainFrameBase;

	/** Instance of table model */
	private EventLogTableModel tableModel;

	private String[] columnToolTips;

	/**
	 * Creates new instance of Messge Event Pane
	 * 
	 * @param mainFrameBase
	 */
	public MsgEventPane(JPanel mainFrameBase) {
		Locale locale = SystemConfigurationFactory.getInstance().getCurrentLocale();
		ResourceBundleManager bundleMngr;
		bundleMngr = new ResourceBundleManager("pl/psnc/expres/wfm/event/EventLog", locale);

		columnToolTips = new String[] { bundleMngr.getValue("table.header.type"),
				bundleMngr.getValue("table.header.sender"),
				bundleMngr.getValue("table.header.date"),
				bundleMngr.getValue("table.header.message"),
				bundleMngr.getValue("table.header.details") };
		initComponents();
		this.mainFrameBase = mainFrameBase;
		this.tableModel = EventLogFactory.getTableModel();
		initTable();

	}

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT
		// MODIFY//GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		jMsgLogScrollPane = new JScrollPane();
		jMsgLogTable = new JTable() {
			// Implement table header tool tips.
			protected JTableHeader createDefaultTableHeader() {
				return new JTableHeader(columnModel) {
					public String getToolTipText(MouseEvent e) {
						String tip = null;
						java.awt.Point p = e.getPoint();
						int index = columnModel.getColumnIndexAtX(p.x);
						int realIndex = columnModel.getColumn(index).getModelIndex();
						return columnToolTips[realIndex];
					}
				};
			}
		};
		jErrorLogToolBar = new JToolBar();
		jCloseBtn = new JButton();
		CellConstraints cc = new CellConstraints();

		// ======== this ========
		setTitle("Message Log");
		setFrameIcon(new ImageIcon(getClass().getResource("/images/buttons/tasks_tsk.gif")));
		setToolBar(jErrorLogToolBar);
		setName("this");
		Container contentPane = getContentPane();
		contentPane.setLayout(new FormLayout("default:grow", "fill:default:grow"));

		// ======== jMsgLogScrollPane ========
		{
			jMsgLogScrollPane.setBorder(Borders.createEmptyBorder("0dlu, 0dlu, 0dlu, 0dlu"));
			jMsgLogScrollPane.setPreferredSize(new Dimension(200, 200));
			jMsgLogScrollPane.setName("jMsgLogScrollPane");

			// ---- jMsgLogTable ----
			jMsgLogTable.setModel(new DefaultTableModel(new Object[][] {
					{ null, null, null, null, null }, { null, null, null, null, null },
					{ null, null, null, null, null }, { null, null, null, null, null },
					{ null, null, null, null, null }, { null, null, "", null, "" }, },
					new String[] { " Type", "Sender", "Date", "Message", "Details" }) {
				Class[] columnTypes = new Class[] { Object.class, String.class, Object.class,
						Object.class, Object.class };
				boolean[] columnEditable = new boolean[] { false, false, false, false, false };

				@Override
				public Class<?> getColumnClass(int columnIndex) {
					return columnTypes[columnIndex];
				}

				@Override
				public boolean isCellEditable(int rowIndex, int columnIndex) {
					return columnEditable[columnIndex];
				}
			});
			jMsgLogTable.setPreferredScrollableViewportSize(new Dimension(100, 200));
			jMsgLogTable.setPreferredSize(new Dimension(610, 200));
			jMsgLogTable.setMaximumSize(new Dimension(2147483647, 4000));
			jMsgLogTable.setMinimumSize(new Dimension(60, 200));
			jMsgLogTable.setRowMargin(4);
			jMsgLogTable.setRowHeight(18);
			jMsgLogTable.setFocusable(false);
			jMsgLogTable.setRequestFocusEnabled(false);
			jMsgLogTable.setName("jMsgLogTable");
			jMsgLogScrollPane.setViewportView(jMsgLogTable);
		}
		contentPane.add(jMsgLogScrollPane, cc.xy(1, 1));

		// ======== jErrorLogToolBar ========
		{
			jErrorLogToolBar.setEnabled(false);
			jErrorLogToolBar.setRollover(true);
			jErrorLogToolBar.setFloatable(false);
			jErrorLogToolBar.setName("jErrorLogToolBar");

			// ---- jCloseBtn ----
			jCloseBtn.setIcon(new ImageIcon(getClass()
					.getResource("/images/buttons/remove_att.gif")));
			jCloseBtn.setRolloverIcon(new ImageIcon(getClass().getResource(
					"/images/buttons/delete_obj.gif")));
			jCloseBtn.setSelectedIcon(null);
			jCloseBtn.setName("jCloseBtn");
			jCloseBtn.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					jCloseBtnActionPerformed(e);
				}
			});
			jErrorLogToolBar.add(jCloseBtn);
		}
		// initialization//GEN-END:initComponents
	}

	private void jCloseBtnActionPerformed(ActionEvent e) {
		// TODO add your code here
	}

	// JFormDesigner - Variables declaration - DO NOT
	// MODIFY//GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JScrollPane jMsgLogScrollPane;
	private JTable jMsgLogTable;
	private JToolBar jErrorLogToolBar;
	private JButton jCloseBtn;

	// JFormDesigner - End of variables declaration//GEN-END:variables

	/**
	 * Initializes the component table
	 */
	private void initTable() {
		// set model
		jMsgLogTable.setModel(tableModel);
		// set renderer
		jMsgLogTable.setDefaultRenderer(Object.class, new EventLogCellRenderer(tableModel));
		jMsgLogTable.getTableHeader().setReorderingAllowed(false);
		// set size
		jMsgLogTable.getColumnModel().getColumn(0).setMinWidth(30);
		jMsgLogTable.getColumnModel().getColumn(0).setMaxWidth(60);
		jMsgLogTable.getColumnModel().getColumn(0).setPreferredWidth(40);

		jMsgLogTable.getColumnModel().getColumn(1).setMinWidth(130);
		jMsgLogTable.getColumnModel().getColumn(1).setPreferredWidth(140);
		jMsgLogTable.getColumnModel().getColumn(1).setMaxWidth(150);

		jMsgLogTable.getColumnModel().getColumn(2).setMinWidth(150);
		jMsgLogTable.getColumnModel().getColumn(2).setPreferredWidth(400);
		jMsgLogTable.getColumnModel().getColumn(2).setMaxWidth(2000);

		// jScrollPane1.setViewportView(jLogEventTable);
	}

}
