/**
 * Created on Aug 26, 2008
 */
package pl.psnc.expres.wfm.graph.marquee;

import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

import org.jgraph.JGraph;

import pl.psnc.expres.model.factory.ResourceFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.wfm.graph.JReferencePopup;
import pl.psnc.graph.model.marquee.CustomMarqueeHandler;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link WfmMarqueeHandler} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class WfmMarqueeHandler extends CustomMarqueeHandler {

	/**
	 * Creates a new instance of {@link WfmMarqueeHandler}
	 * 
	 * @param graph instance of {@link JGraph}
	 */
	public WfmMarqueeHandler(JGraph graph) {
		super(graph);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.BasicMarqueeHandler#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(final MouseEvent e) {
		if (SwingUtilities.isRightMouseButton(e)) {
			try {
				List<ResourceValue> resources = ResourceFactory.getResources();
				JPopupMenu menu = new JReferencePopup(resources, graph, e);
				menu.show(graph, e.getX(), e.getY());
			} catch (ResourceNotFoundException error) {
				error.printStackTrace();
				JMessage.showErrorMessage(graph, error);
			}
		} else if (currentPortView != null && graph.isPortsVisible()) {
			// Remember Start Location
			startPoint = graph.toScreen(currentPortView.getLocation());
			// Remember First Port
			firstPortView = currentPortView;
		} else {
			// Call Superclass
			super.mousePressed(e);
		}
	}

}
