/*
 * DynamicScenarioException.java
 *
 * Created on 13 luty 2004, 16:23
 */

package pl.psnc.expres.wfm.exception;

import pl.psnc.vlab.exception.VlabException;


/** The class represts the exceptions which are thrown in the system.
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @version 1.0
 */
public class WfmException extends VlabException{
    
    /** Error code number */
    private int codeNumber;
    
    /** Stores an instance of the source exception */
    private Exception sourceException;
    
    /** Creates a new instance of DynamicScenarioException
     * @param message short message indicating errror
     */
    public WfmException(String message) {
        super(message);
    }
    
    /**
     * Creates a new instance of DynamicScenarioException
     * @param e the original source exception
     * @param message short message indicating errror
     */
    public WfmException(String message, Exception e) {
        super(message);
        this.sourceException = e;
    }
    
    
    /**
     * Creates a new instance of DynamicScenarioException
     * @param code exception identifier - indicates the cause of the exception
     * @param message short message indicating errror
     */
    public WfmException(String message, int code) {
        super(message);
        this.codeNumber = code;
    }
    
    /**
     * Creates a new instance of DynamicScenarioException
     * @param code exception identifier - indicates the cause of the exception
     * @param e the original source exception
     * @param message short message indicating errror
     */
    public WfmException(String message, int code, Exception e) {
        super(message);
        this.codeNumber = code;
        this.sourceException =e;
    }
    
    
    
    /**
     * Get the exception identifier (code)
     * @return
     */
    public int getErrorCode(){
        return this.codeNumber;
    }
    
    /**
     * Prints this throwable and its backtrace to the specified print writer.
     * @param printWriter print wrtier to use for output
     */
    public void printStackTrace(java.io.PrintWriter printWriter) {
        if(sourceException != null){
            sourceException.printStackTrace(printWriter);
            return;
        }
        super.printStackTrace(printWriter);
        
    }
    
    /**
     * Prints this throwable and its backtrace to the specified print stream.
     * @param printStream stream to use for output
     */
    public void printStackTrace(java.io.PrintStream printStream) {
        if(sourceException != null){
            sourceException.printStackTrace(printStream);
            return;
        }
        super.printStackTrace(printStream);
    }
    
    /**
     * Prints this throwable and its backtrace to the standart error stream
     */
    public void printStackTrace() {
        if(sourceException != null){
            sourceException.printStackTrace();
            return;
        }
        super.printStackTrace();
    }
    
}
