/*
 * MsgEventType.java
 *
 * Created on January 12, 2006, 11:08 AM
 *
 */

package pl.psnc.expres.wfm.event.type;

import java.util.Locale;

import javax.swing.ImageIcon;

import pl.psnc.expres.wfm.management.SystemConfigurationFactory;
import pl.psnc.vlab.util.i18n.ResourceBundleManager;

/**
 * The abstract class definec a parent type for all the message event types
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public abstract class MsgEventType {
    
    /** Holds value of property icon. */
    private ImageIcon icon;
    
    /** Holds value of property type name. */
    private String name = "";
    
    /** Holds an instance of bundle manager */
    static final ResourceBundleManager bundle;
    static {
        Locale locale = SystemConfigurationFactory.getInstance().getCurrentLocale();
        bundle  = new ResourceBundleManager("pl/psnc/expres/wfm/event/EventLog", locale);
    }
    
    /**
     * Creates a new instance of MsgEventType
     * @param keyName name of the key which holds the name of this type
     * @param icon messge type icon
     */
    protected MsgEventType(ImageIcon icon, String keyName) {
        this.icon = icon;
        try{
            this.name = bundle.getValue(keyName);
        }catch(Exception e){
            e.printStackTrace();
            //ok to ignore this one
        }
    }
    
    
    /**
     * Get event type icon.
     * @return event icon.
     */
    public ImageIcon getIcon() {
        return this.icon;
    }
    
    /**
     * Get event type name.
     * @return event name.
     */
    public String getName() {
        return this.name;
    }
    
    /**
     * dummy method. Should be overriden by the subclassing elements
     * @return message event type.
     */
    public  static MsgEventType getType(){
        return null;
    }
    
}
