/*
 * MsgErrorEvent.java
 *
 * Created on January 12, 2006, 11:34 AM
 *
 */

package pl.psnc.expres.wfm.event.type;

import pl.psnc.vlab.util.image.ImageFactory;

/**
 * Messge Log Type - error message
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class MsgErrorEvent extends MsgEventType {
    
    /** Stores error event icon */
    private static final String ERROR_ICON = "images/dialog/message_error.gif";
    
    /** Stores an instance of MsgErrorEvent */
    private static MsgErrorEvent instance;
    
    /** Creates a new instance of MsgErrorEvent */
    private MsgErrorEvent() {
        super(ImageFactory.getImageBean(ERROR_ICON).getImage(), "error.event.type.name");
    }

    /**
     * Get specified event type.
     * @return message event type.
     */
    public static MsgEventType getType() {
        return instance == null ? instance = new MsgErrorEvent() : instance;
    }   
}
