/*
 * ErrorTableModel.java
 *
 * Created on 18 stycze� 2002, 21:19
 */

package pl.psnc.expres.wfm.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.event.value.EventLogValue;
import pl.psnc.expres.wfm.management.SystemConfigurationFactory;
import pl.psnc.vlab.util.DateTools;
import pl.psnc.vlab.util.i18n.ResourceBundleManager;

/**
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class EventLogTableModel extends DefaultTableModel {

	private final Log log = LogFactory.getLog(this.getClass().getName());

	private boolean ALLOW_COLUMN_SELECTION = false;
	private boolean ALLOW_ROW_SELECTION = true;

	/** Table header */
	private String[] columnNames;

	/** Table editable columns */
	private final boolean[] canEdit = { false, false, false, false, false };

	/** Date Tools helper class */
	private DateTools dateTools;

	/** Table data */
	private List eventLogList = new ArrayList();

	/** Time format */
	private final static String TIME_FORMAT = "kk:mm:ss";
	/** Date format */
	private final static String DATE_FORMAT = "dd/MM/yyyy";

	/**
	 * 
	 * @param frame
	 */
	public EventLogTableModel() {
		log.debug("Creating table model");
		Locale locale = SystemConfigurationFactory.getInstance().getCurrentLocale();
		dateTools = new DateTools(locale, DATE_FORMAT, TIME_FORMAT);
		ResourceBundleManager bundleMngr;

		bundleMngr = new ResourceBundleManager("pl/psnc/expres/wfm/event/EventLog", locale);

		columnNames = new String[] { bundleMngr.getValue("table.header.type"),
				bundleMngr.getValue("table.header.sender"),
				bundleMngr.getValue("table.header.date"),
				bundleMngr.getValue("table.header.message"),
				bundleMngr.getValue("table.header.details") };

		for (int i = 0; i < 10; i++) {
			addLogEvent(new EventLogValue());
		}
	}

	/**
	 * Get coresponding value object
	 * 
	 * @param row
	 * @return
	 */
	public EventLogValue getValueAt(int row) {
		return (EventLogValue) eventLogList.get(row);
	}

	/**
	 * Get the number of columns
	 * 
	 * @return
	 */
	public int getColumnCount() {
		return columnNames.length;
	}

	/*
	 * Don't need to implement this method unless your workerListTable's
	 * editable.
	 */
	public boolean isCellEditable(int row, int col) {
		return this.canEdit[col];
	}

	public int getRowCount() {
		return eventLogList == null ? 0 : eventLogList.size();
	}

	public String getColumnName(int col) {
		log.debug("Taking name for the col =" + col);
		return columnNames[col];
	}

	/**
	 * 
	 * @param row
	 * @param col
	 * @return
	 */
	public Object getValueAt(int row, int col) {
		try {
			Object o = eventLogList.get(row);
			if (o == null) {
				return null;
			}
			EventLogValue eventLogVO = (EventLogValue) o;
			switch (col) {
			case 2:
				return eventLogVO.getDate() == null ? "" : dateTools.getDateTimeAsString(eventLogVO
						.getDate());
			case 3:
				return eventLogVO.getMessage();
			case 4:
				return eventLogVO.getDetails();
			}
			return null;
		} catch (IndexOutOfBoundsException err) {
			return null;
		}
	}

	/**
	 * Add new log event to the table model
	 * 
	 * @param logEvent log event
	 */
	public void addLogEvent(EventLogValue logEvent) {
		if (logEvent == null) {
			return;
		}
		eventLogList.add(logEvent);
		Collections.sort(eventLogList);
		fireTableDataChanged();
	}

}