/*
 * WorkerListCellRenderer.java
 *
 * Created on 3 marzec 2003, 12:34
 */

package pl.psnc.expres.wfm.event;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

import pl.psnc.expres.wfm.event.type.MsgEventType;
import pl.psnc.expres.wfm.event.value.EventLogValue;

/**
 * 
 * @author Dominik Stoklosa
 */
public class EventLogCellRenderer extends DefaultTableCellRenderer {

	/** Stores an instance of the coresponding data model */
	private EventLogTableModel tableModel;

	/** Creates a new instance of WorkerListCellRenderer */
	public EventLogCellRenderer(AbstractTableModel tableModel) {
		this.tableModel = (EventLogTableModel) tableModel;
	}

	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		setBackground(Color.white);
		setOpaque(true);
		setIcon(null);
		if (value != null) {
			setToolTipText(value.toString());
		}
		EventLogValue logValue = tableModel.getValueAt(row);

		if (column == 0) { // log type
			setHorizontalAlignment(SwingConstants.CENTER);
			MsgEventType type = logValue.getType();
			if (type != null) {
				setIcon(type.getIcon());
				setToolTipText(type.getName());
			}

		} else if (column == 1) { // date
			setHorizontalAlignment(SwingConstants.CENTER);
		} else if (column == 2) { // messgae
			setHorizontalAlignment(SwingConstants.LEFT);
		} else if (column == 2) { // messgae
			setHorizontalAlignment(SwingConstants.LEFT);
		}

		/*
		 * //color selected row int[] iSelectedRows = table.getSelectedRows();
		 * if (iSelectedRows != null) { for(int i=0; i< iSelectedRows.length;
		 * i++) { if (iSelectedRows[i] == row) { isSelected = true;
		 * setBackground(Keys.COLOR_SELECTED_LIGHT_GRAY); break; } } }
		 */

		return this;
	}

}