package pl.psnc.expres.wfm.action.perspective;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.expres.wfm.gui.perspective.JWelcomePane;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.GraphHelper;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link WelcomePaneAction} class - shows the welcome pane, which is displayed
 * when the application is launched
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class WelcomePaneAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance ofWelcomePaneAction. The action is created with
	 * the default name, icons, mnemonic and accelerator key - these are taken
	 * from the resource bundle
	 */
	public WelcomePaneAction() {
		super("action.welcome.pane.name", null, "action.welcome.pane.tip");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			log.debug("WelcomePaneAction");
			// check whether the current graph is empty
			CustomGraph graph = getCurrentGraph();
			int result = 0;
			if (GraphHelper.isEmpty(graph)
					&& ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).isEnabled()) {
				log.debug("An old secenario exists");
				result = JMessage.showConfirmQuestionMessage(mainFrame,
						 BundleFactory.getMessageValue("message.another.scenario.in.use"),
						JMessage.YES_NO_OPTION);

				if (result != JMessage.YES_OPTION) {
					log.debug("Do not close scenario");
					return;
				}
			}
			// TODO impl
			mainFrame.addMainContentPane(JWelcomePane.class, false);
			ResInfPerspAction resOutline = (ResInfPerspAction) ActionFactory
					.getAction(WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE);
			if (resOutline.isVisible()) {
				resOutline.actionPerformed(e);
			}
			resOutline.setEnabled(false);
			ActionFactory.getAction(WfmActionType.SCENARIO_PROPERTIES).setEnabled(false);
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(mainFrame, err.getLocalizedMessage());
		}

	}

}
