package pl.psnc.expres.wfm.action.factory;

import pl.psnc.expres.wfm.action.CloseAppAction;
import pl.psnc.expres.wfm.action.CloseScenarioAction;
import pl.psnc.expres.wfm.action.NewScenarioAction;
import pl.psnc.expres.wfm.action.OpenFileAction;
import pl.psnc.expres.wfm.action.SaveFileAction;
import pl.psnc.expres.wfm.action.SaveFileAsAction;
import pl.psnc.expres.wfm.action.ScenarioPropertiesAction;
import pl.psnc.expres.wfm.action.SubmitWorkflowAction;
import pl.psnc.expres.wfm.action.ccf.OpenVexFileAction;
import pl.psnc.expres.wfm.action.perspective.CcfEditorPaneAction;
import pl.psnc.expres.wfm.action.perspective.EventLogPerspAction;
import pl.psnc.expres.wfm.action.perspective.ResInfPerspAction;
import pl.psnc.expres.wfm.action.perspective.WelcomePaneAction;
import pl.psnc.expres.wfm.action.perspective.WorkflowEditorViewAction;
import pl.psnc.vlab.util.gui.action.AbstractActionDefault;
import pl.psnc.vlab.util.gui.action.factory.ActionType;

/**
 * {@link WfmActionType} class - defines all possible actions for WFM
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public enum WfmActionType implements ActionType {

	SCENARIO_NEW(NewScenarioAction.class),
	SCENARIO_OPEN(OpenFileAction.class),
	SCENARIO_CLOSE(CloseScenarioAction.class),
	SCENARIO_SAVE(SaveFileAction.class),
	SCENARIO_SAVE_AS(SaveFileAsAction.class),
	SCENARIO_SUBMIT(SubmitWorkflowAction.class),
	SCENARIO_PROPERTIES(ScenarioPropertiesAction.class),

	VEX_OPEN(OpenVexFileAction.class),

	APP_EXIT(CloseAppAction.class),

	PERSPECTIVE_RESOURCE_OUTLINE(ResInfPerspAction.class),
	PERSPECTIVE_EVENT_LOG(EventLogPerspAction.class),
	PERSPECTIVE_WELCOME(WelcomePaneAction.class),
	PERSPECTIVE_CCF_EDITOR(CcfEditorPaneAction.class),
	PERSPECTIVE_WORKFLOW_EDITOR(WorkflowEditorViewAction.class);

	/** Stores action type */
	private Class<? extends AbstractActionDefault> type;

	/**
	 * Creates new WfmActionType
	 * 
	 */
	private WfmActionType(Class<? extends AbstractActionDefault> type) {
		this.type = type;
	}

	// ----------------------------------------------------------------------------------------
	// ---- Getters

	/**
	 * Get type of the given action object
	 * 
	 * @return type of the given action object
	 */
	public Class<? extends AbstractActionDefault> getType() {
		return type;
	}

}
