package pl.psnc.expres.wfm.action.ccf;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.MalformedURLException;
import java.util.List;

import javax.swing.Action;
import javax.swing.JFileChooser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.graph.DefaultGraphCell;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.factory.CcfFactory;
import pl.psnc.expres.model.factory.VlbiExperimentFactory;
import pl.psnc.expres.model.resource.ResourceValue;
import pl.psnc.expres.model.type.ResourceType;
import pl.psnc.expres.remote.vex2ccf.model.CCFValue;
import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.expres.wfm.exception.WfmException;
import pl.psnc.expres.wfm.gui.main.JMainFrame;
import pl.psnc.expres.wfm.model.factory.TypeFactory;
import pl.psnc.expres.wfm.model.factory.WfmResourceFactory;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.expres.wfm.util.i18n.helper.MessageKeys;
import pl.psnc.graph.factory.GraphCellFactory;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.io.ChooserType;
import pl.psnc.graph.io.FileChooserFactory;
import pl.psnc.graph.io.FileFilterType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.GraphHelper;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.FileTools;
import pl.psnc.vlab.util.gui.action.AbstractActionDefault;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.message.JMessage;
import pl.psnc.vlab.util.gui.progress.JStatusBar;
import pl.psnc.vlab.util.gui.progress.ProgressTask;
import pl.psnc.vlab.util.thread.DefaultLongTask;
import pl.psnc.vlab.util.thread.LongTaskResult;

/**
 * {@link OpenVexFileAction} class - based on the VEX file, the Correlator
 * Control File (CCF) is created and radio telescopes from the observation file
 * are located on the application design pane
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class OpenVexFileAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of Open VEX File Action. The open action is used
	 * to clone the existing nodes. The action is created with the default name,
	 * icons, mnemonic and accelerator key - these are taken from the resource
	 * bundle
	 * 
	 * @param source the source swing component, which uses this action
	 */
	public OpenVexFileAction() {
		super("action.open.vex.file.name", ImageKeys.ICON_OPEN, "action.open.vex.file.tip");
		setMnemonic("action.open.vex.file.mnemonic");
		setAcceleratorKey("action.open.vex.file.shortcut");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		JStatusBar progress = JMainFrame.getInstance().getJStatusBar();
		LongTask longTask = new LongTask(progress, this);
		longTask.execute();
	}

	// --------------------------------------------------------------------------
	// ----- Private, internal helper methods and classes

	/**
	 * {@link LongTask} - long task run in background, performs all the tasks
	 * required to open Vex file
	 * 
	 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
	 * @email osa@man.poznan.pl
	 * 
	 */
	private class LongTask extends DefaultLongTask {

		/** Stores instance of field: vlbiExp */
		private VlbiExperiment vlbiExp;

		/**
		 * Create a new instance of GiveArtBackTask
		 */
		LongTask(ProgressTask progres, Action action) {
			super(progres, action);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.SwingWorker#doInBackground()
		 */
		@Override
		protected LongTaskResult doInBackground() throws Exception {
			log.debug("<doInBackground: OpenVexFile>");
			setEnabled(false);
			showProgress(true);
			updateProgress("");

			AbstractActionDefault action = ActionFactory
					.getAction(WfmActionType.PERSPECTIVE_WORKFLOW_EDITOR);
			action.actionPerformed(null);

			// check whether the current graph is empty
			CustomGraph graph = getCurrentGraph();
			int result = 0;
			if (!GraphHelper.isEmpty(graph)) {
				log.debug("An old secenario exists");
				String msg = BundleFactory.getMessageValue("message.another.scenario.in.use");
				result = JMessage
						.showConfirmQuestionMessage(mainFrame, msg, JMessage.YES_NO_OPTION);

				if (result == JMessage.NO_OPTION) {
					log.debug("Do not close scenario");
					log.debug("</actionPerformed>");
					return null;
				}
			}

			File file = getFileToOpen();
			if (file == null) { // CANCEL OPTION
				log.debug("</actionPerformed:cancel>");
				return null;
			}

			// parse VEX file
			String ccf = convertVexFile(file);
			vlbiExp = VlbiExperimentFactory.getInstance();
			// TODO throw exception when vex is null
			byte[] vex = FileTools.getContent(file);
			vlbiExp.setVexFile(vex);

			CCFValue ccfValue = CcfFactory.getCcfModel(ccf);
			vlbiExp.setCcf(ccfValue);

			// put radio telescopes on design pane
			loadGraph(ccfValue);

			updateActions();
			return null;
		}

		/**
		 * Returns the File object representing the file to be opened.
		 * 
		 * @return File object or null if Cancel option has been chosen.
		 */
		private File getFileToOpen() throws MalformedURLException {
			JFileChooser chooser = FileChooserFactory.getFileChooser(ChooserType.OPEN,
					FileFilterType.XML);
			int result = chooser.showOpenDialog(mainFrame);
			if (result == JFileChooser.CANCEL_OPTION) {
				return null;
			}
			return chooser.getSelectedFile();
		}

		/**
		 * Convert the given vex file into the correlator control file
		 * 
		 * @param vexFile vex file
		 * @return CCF file, created based on Vex file
		 * @throws WfmException thrown when the remote service fails
		 */
		private String convertVexFile(File vexFile) throws WfmException,
				pl.psnc.vlab.exception.ResourceNotFoundException {
			log.debug("<convertVexFile>");
			String msg = BundleFactory.getMessageValue(MessageKeys.OPEN_VEX_IN_PROGRESS);
			updateProgress(msg);

			// Dummy code
			File file = new File("resources/model/ccf-sample.json");
			byte[] content = FileTools.getContent(file);
			return new String(content);

			// BufferedReader vexReader = null;
			// try {
			// Vex2CcfStub vexStub = new Vex2CcfStub();
			// Vex2CcfStub.ConvertRequest convertRequest = new
			// Vex2CcfStub.ConvertRequest();
			// // BufferedReader vexReader = new BufferedReader(new FileReader(
			// //
			// "/home/osa/cvs/sources/expres/expresRemote/resources/n06c2.vix"));
			// vexReader = new BufferedReader(new FileReader(vexFile));
			//
			// String line = null;
			// StringBuffer res = new StringBuffer();
			// while ((line = vexReader.readLine()) != null) {
			// res.append(line).append(FileTools.LINE_SEPARATOR);
			// }
			// convertRequest.setVex_file(res.toString());
			// Vex2CcfStub.ConvertResponse resp =
			// vexStub.convert(convertRequest);
			// String ccf_file = resp.getCcf_file();
			// log.debug("Ccf=" + ccf_file);
			// if (FormTools.isValidateFormStringNull(ccf_file)) {
			// log.debug("</convertVexFile: null>");
			// // TODO add i18n
			// throw new WfmException("Wrong Vex file");
			// }
			// return ccf_file;
			// } catch (Exception e) {
			// // TODO add error codes and localization
			// throw new WfmException(e.getMessage(), e);
			// } finally {
			// if (vexReader != null) {
			// try {
			// vexReader.close();
			// } catch (IOException e) {
			// log.error(e.getMessage());
			// }
			// }
			// }
		}

		/**
		 * Loads a list of radio telescoped from the given CCF instance.
		 * 
		 * @param ccfValue instance of {@link CCFValue}
		 * @throws Exception
		 */
		private void loadGraph(CCFValue ccfValue) throws Exception {
			log.debug("<loadGraph>");
			if (ccfValue == null) {
				// TODO add i18n
				throw new ResourceNotFoundException("CCF file is empty.");
			}
			String msg = BundleFactory.getMessageValue(MessageKeys.OPEN_VEX_LOAD_RADIO_TELESCOPES);
			updateProgress(msg);

			// CustomGraph graph = getCurrentGraph();

			List<String> stations = ccfValue.getStations();
			if (stations == null) {
				// TODO add i18n
				throw new ResourceNotFoundException("Station definition is missing.");
			}
			int i = 0;
			log.debug("Size=" + stations.size());

			for (String station : stations) {
				log.debug("Station=" + station);
				ResourceValue resource = WfmResourceFactory.getResource(station);
				vlbiExp.getResources().add(resource);				
				
				ResourceType resType = TypeFactory.getResourceType(resource.getTypeId());

				DefaultGraphCell imageGraphCell = GraphCellFactory.createCell(resType, resource);
				Point2D p = new Point2D.Double(100 + i * 80, 50 + i * 10);
				GraphEditorFactory.getGraphEditorInstance().insert(p, imageGraphCell);
				i++;
			} // end of for
			log.debug("</loadGraph>");
		}

		/**
		 * Updates the corresponding and related actions
		 * 
		 */
		private void updateActions() throws ResourceNotFoundException {
			ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).setEnabled(false);
			// ActionFactory.getAction(WfmActionType.ACTION_ADD_VERTEX_COMPUTE).setEnabled(true);
			// TODO impl
			// ActionFactory.getAction(ActionFactory.ACTION_ADD_VERTEX_EXPERIMENT).setEnabled(true);
			ActionFactory.getAction(WfmActionType.SCENARIO_CLOSE).setEnabled(true);
			ActionFactory.getAction(WfmActionType.PERSPECTIVE_WELCOME).setEnabled(true);
			ActionFactory.getAction(WfmActionType.SCENARIO_PROPERTIES).setEnabled(true);
			
			ActionFactory.getAction(WfmActionType.SCENARIO_SUBMIT).setEnabled(true);
			
			// Action action = ActionFactory
			// .getAction(WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE);
			// action.setEnabled(true);
			// action.actionPerformed(e);

			// FileChooserFactory.getFileChooser(
			// FileChooserFactory.TYPE_SAVE_DIALOG).setSelectedFile(file);
			// FileChooserFactory.setSelectedFileName(file.getName());
			// updateFrameTitle(file.getName());
			// TODO impl
			// mainFrame.getBasePane().getJScenDetailsPane().update(null,
			// ScenarioBuilder.getExperimentDetails());
		}
	}
}
