package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.factory.VlbiExperimentFactory;
import pl.psnc.expres.remote.broker.impl.SubmitVlbiExperimentStub;
import pl.psnc.expres.remote.broker.xsd.StartVlbiExperiment;
import pl.psnc.expres.remote.helper.RemoteHelper;
import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.expres.wfm.util.i18n.helper.MessageKeys;
import pl.psnc.vlab.util.thread.DefaultLongTask;
import pl.psnc.vlab.util.thread.LongTaskResult;

/**
 * {@link SubmitWorkflowAction} class - represents workfow submission action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class SubmitWorkflowAction extends WfmAbstractAction {

	/** Stores instance of field: serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of Scenario Submission Action.
	 * 
	 * The action is created with the default name, icons, mnemonic and
	 * accelerator key - these are taken from the resource bundle
	 */
	public SubmitWorkflowAction() {
		super("action.submit.scenario.name", ImageKeys.ICON_SUBMIT, "action.submit.scenario.tip");
		setMnemonic("action.submit.scenario.mnemonic");
		setAcceleratorKey("action.submit.scenario.shortcut");
		setDisabledActionIcon(ImageKeys.ICON_SUBMIT_DISABLED);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		new SubmitWorkflowTask().execute();
	}

	/**
	 * {@link SubmitWorkflowTask} class - long task run in background, sends
	 * observation scenario to the vlbi broker
	 * 
	 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
	 * @email osa@man.poznan.pl
	 * 
	 */
	private class SubmitWorkflowTask extends DefaultLongTask {

		/**
		 * Create a new instance of AssignArticlesTask
		 */
		public SubmitWorkflowTask() {
			super(mainFrame, mainFrame.getJStatusBar(), SubmitWorkflowAction.this);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.SwingWorker#doInBackground()
		 */
		@Override
		protected LongTaskResult doInBackground() throws Exception {
			setEnabled(false);
			showProgress(true);

			String message = BundleFactory.getMessageValue(MessageKeys.SUBMIT_SCENARIO_IN_PROGRESS);
			updateProgress(message);
			SubmitVlbiExperimentStub stub = new SubmitVlbiExperimentStub();

			VlbiExperiment vlbiExperiment = VlbiExperimentFactory.getInstance();
			StartVlbiExperiment newVlbiExperiment = RemoteHelper.getNewVlbiExperiment(vlbiExperiment);
			stub.startVlbiExperiment(newVlbiExperiment);

			message = BundleFactory.getMessageValue(MessageKeys.SUBMIT_SCENARIO_OK);
			return new LongTaskResult(message, false);
		}
	}

}
