package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import pl.psnc.expres.model.experiment.ExperimentInfo;
import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.gui.scenario.JScenarioPropertiesPane;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.expres.xml.ScenarioBuilder;

/**
 * {@link ScenarioPropertiesAction} class - scenario properties action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ScenarioPropertiesAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of Scenario Properties Action. The action is used
	 * to open an Scenario properties dialog
	 */
	public ScenarioPropertiesAction() {
		super("action.scenario.properties.name", ImageKeys.ICON_PROPERTIES,
				"action.scenario.properties.tip");
		setMnemonic("action.scenario.properties.mnemonic");
		setAcceleratorKey("action.scenario.properties.shortcut");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.AbstractActionDefault#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		ExperimentInfo scenario = ScenarioBuilder.getExperimentDetails();
		new JScenarioPropertiesPane(mainFrame, scenario).setVisible(true);
	}

}
