package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.gui.resource.model.ResourceElementObserver;
import pl.psnc.expres.wfm.util.ImageKeys;

/**
 * {@link SaveFileAsAction} class - the action for saving the scenario (save
 * as).
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class SaveFileAsAction extends WfmAbstractAction implements
		ResourceElementObserver {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	private static String scenarioInfoFile = null;

	/**
	 * Creates a new instance of save Action. The save action is used to clone
	 * the existing nodes. The action is created with the default name, icons,
	 * mnemonic and accelerator key - these are taken from the resource bundle
	 * 
	 * @param source the source swing component, which uses this action
	 */
	public SaveFileAsAction() {
		super("action.save.as.name", ImageKeys.ICON_SAVE_AS, "action.save.as.tip");
		setMnemonic("action.save.as.mnemonic");
		setAcceleratorKey("action.save.as.shortcut");
		setDisabledActionIcon(ImageKeys.ICON_SAVE_AS_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		 
	}

	/**
	 * Notifies the observers that they should update their data
	 */
	public void update() {
		setEnabled(true);
	}

	/**
	 * Enables or disables the action.
	 * 
	 * @param newValue true to enable the action, false to disable it
	 * @see Action#setEnabled
	 */
	public void setEnabled(boolean newValue) {
		super.setEnabled(newValue);
	}

}
