package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.util.JGraphUtilities;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.util.ImageKeys;
import pl.psnc.graph.factory.GraphEditorFactory;
import pl.psnc.graph.gui.JGraphPane;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.vlab.exception.VlabException;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link OpenFileAction} class - open file action
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public class OpenFileAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Creates a new instance of Open Action. The open action is used to clone
	 * the existing nodes. The action is created with the default name, icons,
	 * mnemonic and accelerator key - these are taken from the resource bundle
	 * 
	 * @param source the source swing component, which uses this action
	 */
	public OpenFileAction() {
		super("action.open.name", ImageKeys.ICON_OPEN, "action.open.tip");
		setMnemonic("action.open.mnemonic");
		setAcceleratorKey("action.open.shortcut");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			log.debug("<actionPerformed>");
			// check whether the current graph is empty
			// CustomGraph graph = getCurrentGraph();
			// int result = 0;
			// if (graph != null && !graph.isEmpty()) {
			// log.debug("An old secenario exists");
			// String msg = MessageBundleFactory
			// .getValue("message.another.scenario.in.use");
			// result = JMessage.showConfirmQuestionMessage(mainFrame, msg,
			// JMessage.YES_NO_OPTION);
			//
			// if (result == JMessage.NO_OPTION) {
			// log.debug("Do not close scenario");
			// log.debug("</actionPerformed>");
			// return;
			// }
			// }

			URL file = null;
			file = getFileToOpen();
			if (file == null) { // CANCEL OPTION
				log.debug("</actionPerformed:cancel>");
				return;
			}
			log.debug("File=" + file);
			loadGraph(file);
			updateActions(new File(file.getFile()), e);
			log.debug("</actionPerformed>");
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
			JMessage.showErrorMessage(mainFrame, err.getLocalizedMessage());
		}

	}

	/**
	 * Update the Main Frame Base top component title
	 * 
	 * @param modified
	 */
	public void updateFrameTitle(String name) {
		// TODO - implement this
		// ((JMainFrame)mainFrame).getBasePane().setTitle(name, false);
	}

	// --------------------------------------------------------------------------
	// ----- Private, internal helper methods

	/**
	 * Returns the File object representing the file to be opened.
	 * 
	 * @return File object or null if Cancel option has been chosen.
	 */
	private URL getFileToOpen() throws MalformedURLException {
		// GraphFileChooser chooser = (GraphFileChooser) FileChooserFactory
		// .getFileChooser(FileChooserFactory.TYPE_OPEN_DIALOG);
		// int result = chooser.showOpenDialog(mainFrame);
		// if (result == JFileChooser.CANCEL_OPTION) {
		return null;
		// }
		// return chooser.getSelectedFile().toURL();
	}

	/**
	 * Load graph from the given URL
	 * 
	 * @param url URL representing graph
	 * @throws java.lang.Exception
	 */
	private void loadGraph(URL url) throws Exception {
		log.debug("<loadGraph>");
		String file = url.getFile();
		// Extract the provider and the file format
		// final GraphModelProvider graphModelProvider =
		// GraphModelProviderRegistry
		// .getGraphModelProvider(file);
		// final GraphModelFileFormat graphModelFileFormat =
		// GraphModelProviderRegistry
		// .getGraphModelFileFormat(file);

		// create new grap editor object instance

		// TODO faulty code - fix required
		JGraphPane graphEditorInstance = GraphEditorFactory.getGraphEditorInstance();
		CustomGraph graph = graphEditorInstance.getGraph();

		// GraphModel newModel = graphModelFileFormat.read(url, null, graph);

		// if (newModel == null) {
		// log.debug("</loadGraph:no model>");
		// throw new WfmException(MessageBundleFactory
		// .getValue("message.file.incorrect"));
		// }
		graph.repaint();
		graph.invalidate();
		Object list[] = JGraphUtilities.getVertices(graph, JGraphUtilities.getAll(graph));
		int size = list != null ? list.length : 0;
		for (int i = 0; i < size; i++) {
			// DefaultGraphCell cell = (DefaultGraphCell) list[i];
			// GraphCellObject cellObject = (GraphCellObject)
			// cell.getUserObject();
			// TODO removed to compile
			// ResourceValue resource = cellObject != null ?
			// cellObject.getResource() : null;
			// if (resource != null) {
			// resource.setId(WfmResourceFactory.nextSequenceNumber());
			// log.debug("New node id-" + resource.getId());
			// }
		} // end of for
		log.debug("</loadGraph>");
	}

	/**
	 * Updates the coresponding and related actions
	 * 
	 * @param file loaded file
	 * @param e ActionEvent
	 */
	private void updateActions(File file, ActionEvent e) throws VlabException {
		// ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).setEnabled(false);
		// ActionFactory.getAction(WfmActionType.ACTION_ADD_VERTEX_COMPUTE).setEnabled(true);
		// TODO impl
		// ActionFactory.getAction(ActionFactory.ACTION_ADD_VERTEX_EXPERIMENT).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.SCENARIO_CLOSE).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.PERSPECTIVE_WELCOME).setEnabled(true);
		// ActionFactory.getAction(WfmActionType.SCENARIO_PROPERTIES).setEnabled(true);
		// Action action =
		// ActionFactory.getAction(WfmActionType.PERSPECTIVE_RESOURCE_OUTLINE);
		// action.setEnabled(true);
		// action.actionPerformed(e);

		// FileChooserFactory.getFileChooser(FileChooserFactory.TYPE_SAVE_DIALOG)
		// .setSelectedFile(file);
		// FileChooserFactory.setSelectedFileName(file.getName());
		updateFrameTitle(file.getName());
		// TODO impl
		// mainFrame.getBasePane().getJScenDetailsPane().update(null,
		// ScenarioBuilder.getExperimentDetails());
	}
}
