package pl.psnc.expres.wfm.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.wfm.action.factory.WfmAbstractAction;
import pl.psnc.expres.wfm.action.factory.WfmActionType;
import pl.psnc.expres.wfm.util.i18n.helper.BundleFactory;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.GraphHelper;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.message.JMessage;

/**
 * {@link CloseAppAction} class - close application action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CloseAppAction extends WfmAbstractAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(CloseAppAction.class);

	/**
	 * Creates a new instance of Exit Action. The action is created with the
	 * default name, icon, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public CloseAppAction() {
		super("action.exit.name", null, "action.exit.tip");
		setMnemonic("action.exit.mnemonic");
		setAcceleratorKey("action.exit.shortcut");
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			// check whether the current graph is empty
			CustomGraph graph = getCurrentGraph();
			int result = 0;
			if (GraphHelper.isEmpty(graph)
					&& ActionFactory.getAction(WfmActionType.SCENARIO_SAVE).isEnabled()) {
				log.debug("An old secenario exists");
				String msg = BundleFactory.getMessageValue("message.another.scenario.in.use");
				result = JMessage
						.showConfirmQuestionMessage(mainFrame, msg, JMessage.YES_NO_OPTION);
				if (result != JMessage.YES_OPTION) {
					log.debug("Do not close scenario");
					return;
				}
			}
			System.exit(0);
		} catch (Exception err) {
			JMessage.showErrorMessage(mainFrame, err);
			System.exit(0);
		}

	}
}
